package com.ypsx.base.util

import com.elvishew.xlog.LogLevel
import com.elvishew.xlog.flattener.Flattener2
import java.text.SimpleDateFormat
import java.util.*

class XLogFlattener : Flattener2 {
    private val DATE_FORMATTER = "yyyy-MM-dd HH:mm:ss.SSS"
    private val sdf = SimpleDateFormat(DATE_FORMATTER, Locale.CHINA)
    override fun flatten(
        timeMillis: Long,
        logLevel: Int,
        tag: String?,
        message: String?
    ): CharSequence {

        val date = Date(timeMillis)
        return (sdf.format(date)
                + '|' + LogLevel.getShortLevelName(logLevel)
                + '|' + tag
                + '|' + message)
    }
}