package com.ypsx.yppos

import org.hamcrest.MatcherAssert.assertThat
import org.junit.Test

/**
 * Example local unit test, which will execute on the development machine (host).
 *
 * See [testing documentation](http://d.android.com/tools/testing).
 */
class ExampleUnitTest {

    @Test
    fun emailValidator_CorrectEmailSimple_ReturnsTrue() {
//        assertThat(EmailValidator.isValidEmail("name@email.com")).isTrue()
    }
    @Test
    fun addition_isCorrect() {
//        assertEquals(4, 2 + 2)
        val stringBuilder = StringBuilder("24")
        val mnemonicCode = "63575"
        val weightCode = "23340"
        val priceCode = "00400"
        stringBuilder.append(mnemonicCode)
        stringBuilder.append(priceCode)
        stringBuilder.append(weightCode)
        print("246357500400233406")
        print(checkCode128(stringBuilder.toString(), 18))

    }

    private fun checkCode128(code: String, codeLength: Int): String {
        var code1 = code
        return if (code.length == codeLength - 1) {
            var c1 = 0
            var c2 = 0
            run {
                var i = 0
                while (i < code.length) {
                    val c = code[i]
                    //字符串code中第i个位置上的字符
                    val n = c - '0'
                    c1 += n //累加奇数位的数字和
                    i += 2
                }
            }
            var i = 1
            while (i < code.length) {
                val c = code[i] //字符串code中第i个位置上的字符
                val n = c - '0'
                c2 += n //累加偶数位的数字和
                i += 2
            }
            val count = c2 + c1 * 3
            val check = (10 - count % 10) % 10
            code1 += check.toString() + ""
            code1
        } else {
            ""
        }
    }

    @Test
    fun printPrice() {
        print(getPriceSpace("20110593", 12.345, 11.0, 37.04))
    }

    private fun getPriceSpace(
        barCode: String,
        paymentProductQuantity: Double,
        price: Double,
        productAmount: Double
    ): String {
        val builder = StringBuilder()
        builder.append(barCode)
        for (i in 0 until 14 - length(barCode)) {
            builder.append(" ")
        }
        builder.append(paymentProductQuantity.toString())
        for (i in 0 until 6 - length(paymentProductQuantity.toString())) {
            builder.append(" ")
        }
        for (i in 0 until 7 - length(price.toString())) {
            builder.append(" ")
        }
        builder.append(price.toString())

        for (i in 0 until 6 - length(productAmount.toString())) {
            builder.append(" ")
        }
        builder.append(productAmount.toString())
        return builder.toString()
    }

    private fun length(value: String): Int {
        var valueLength = 0
        val chinese: String = "[\u0391-\uFFE5]"
        /* 获取字段值的长度，如果含中文字符，则每个中文字符长度为2，否则为1 */
        for (i in value.indices) {
            /* 获取一个字符 */
            val temp = value.substring(i, i + 1)
            /* 判断是否为中文字符 */
            valueLength += if (temp.matches(Regex(chinese))) {
                /* 中文字符长度为2 */
                2
            } else {
                /* 其他字符长度为1 */
                1
            }
        }
        return valueLength
    }
}