package com.ypsx.yppos.viewmodel.state

import com.ypsx.base.base.viewmodel.BaseViewModel
import com.ypsx.base.callback.databind.StringObservableField
import com.ypsx.base.util.AppUtils
import com.ypsx.yppos.room.repository.PosConfigRepository
import com.ypsx.yppos.utils.CacheUtil

class SettingsViewModel : BaseViewModel() {
    var version = StringObservableField()
    var storeName = StringObservableField()
    var userName = StringObservableField()
    var posCode = StringObservableField()




    init {
        val loadConfig = PosConfigRepository.getInstance().loadConfig()

        version.set("版本号：V${AppUtils.getAppVersionName()}")
        val loginResponse = CacheUtil.getLoginResponse()
        storeName.set(loadConfig?.storeName)
        userName.set("用户：${loginResponse?.loginUser?.realName}")
        posCode.set("机号：${loadConfig?.code}")

    }




}