package com.ypsx.yppos.viewmodel.state

import android.view.View
import androidx.databinding.ObservableInt
import androidx.lifecycle.viewModelScope
import com.ypsx.base.base.viewmodel.BaseViewModel
import com.ypsx.base.callback.databind.BooleanObservableField
import com.ypsx.base.callback.databind.StringObservableField
import com.ypsx.yppos.http.data.entity.PosPayMethod
import com.ypsx.yppos.room.repository.PosConfigRepository
import kotlinx.coroutines.launch

class OrderPayAmountViewModel : BaseViewModel() {

    var orderNo = StringObservableField()

    var payAmount = StringObservableField()

    var discountCoupon = StringObservableField()


    var scanOffline = BooleanObservableField(false)

    var scanCardPay = BooleanObservableField(false)
    var scanCashPay = BooleanObservableField(false)

    var payName = StringObservableField("")
    var firstName = StringObservableField("")


    var offlineVisible = object : ObservableInt(scanOffline) {
        override fun get(): Int {
            return if (scanOffline.get()) {
                View.VISIBLE
            } else {
                View.GONE
            }
        }
    }

    var cashVisible = object : ObservableInt(scanCashPay) {
        override fun get(): Int {
            return if (scanCashPay.get()) {
                View.VISIBLE
            } else {
                View.GONE
            }
        }
    }

    var cardPayVisible = object : ObservableInt(scanCardPay) {
        override fun get(): Int {
            return if (scanCardPay.get()) {
                View.VISIBLE
            } else {
                View.GONE
            }
        }
    }

    init {
        viewModelScope.launch {
            val posConfig = PosConfigRepository.getInstance().loadConfig()
            val payMethods = posConfig?.payMethods
//            payMethods.toString().dXLog()
            if (!payMethods.isNullOrEmpty()) {
                val payMethod:List<String> = payMethods.split(",")
                for (str in payMethod) {
                    when (str) {
                        PosPayMethod.CCB_BAR_PAY.name,
                        PosPayMethod.LCSW_BAR_PAY.name -> {
                            payName.set(str)
                            scanOffline.set(true)
                        }
                        PosPayMethod.CARDPAY.name -> scanCardPay.set(true)
                        PosPayMethod.CASHPAY.name -> scanCashPay.set(true)
                    }
                }
                when {
                    payMethods.contains(PosPayMethod.CASHPAY.name) -> {
                        firstName.set(PosPayMethod.CASHPAY.name)
                        return@launch
                    }
                    payMethods.contains(PosPayMethod.CCB_BAR_PAY.name) -> {
                        firstName.set(PosPayMethod.CCB_BAR_PAY.name)
                        return@launch
                    }
                    payMethods.contains(PosPayMethod.LCSW_BAR_PAY.name) -> {
                        firstName.set(PosPayMethod.LCSW_BAR_PAY.name)
                        return@launch
                    }
                    payMethods.contains(PosPayMethod.CARDPAY.name) -> {
                        firstName.set(PosPayMethod.CARDPAY.name)
                        return@launch
                    }

                }



            }
        }

    }


}