package com.ypsx.yppos.viewmodel.state

import android.view.View
import androidx.databinding.ObservableInt
import com.ypsx.base.base.viewmodel.BaseViewModel
import com.ypsx.base.callback.databind.BooleanObservableField
import com.ypsx.base.callback.databind.StringObservableField

class AppUpdaterViewModel : BaseViewModel() {


    var appVersion = StringObservableField()

    var appCancel = BooleanObservableField(false)

    var updaterShow = BooleanObservableField(true)

    var progressBarShow = BooleanObservableField(false)


    var cancelVisibility = object : ObservableInt(appCancel) {
        override fun get(): Int {
            return if (appCancel.get()) {
                View.VISIBLE
            } else {
                View.GONE
            }
        }
    }

    var updaterVisibility = object : ObservableInt(updaterShow) {
        override fun get(): Int {
            return if (updaterShow.get()) {
                View.VISIBLE
            } else {
                View.GONE
            }
        }
    }


    var progressBarVisibility = object : ObservableInt(progressBarShow) {
        override fun get(): Int {
            return if (progressBarShow.get()) {
                View.VISIBLE
            } else {
                View.GONE
            }
        }
    }







}