package com.ypsx.yppos.ui.popup

import android.content.Context
import android.text.TextUtils
import android.util.Log
import android.view.Gravity
import android.view.KeyEvent
import android.view.View
import android.view.inputmethod.EditorInfo
import com.ypsx.base.base.appContext
import com.ypsx.base.ext.util.hideSoftKeyboard
import com.ypsx.base.ext.util.screenWidth
import com.ypsx.base.util.dXLog
import com.ypsx.yppos.R
import com.ypsx.yppos.databinding.PopupScanCouponBinding
import com.ypsx.yppos.utils.scan.ScanGunKeyEventHelper
import razerdp.basepopup.BasePopupWindow

class ScanCouponPopupWindow(context: Context,scanGunKeyEventHelper:ScanGunKeyEventHelper) : BasePopupWindow(context),
    ScanGunKeyEventHelper.OnScanSuccessListener {
    var binding: PopupScanCouponBinding? = null
    lateinit var scanGunKeyEventHelper:ScanGunKeyEventHelper
    private var scanCouponAction: (couponCode: String) -> Unit = { }

    init {
        setContentView(R.layout.popup_scan_coupon)
        width = appContext.screenWidth / 4 * 3
        popupGravity = Gravity.CENTER
        isOutSideTouchable = true
        setOutSideDismiss(true)
        setBackPressEnable(false)
        setAutoShowKeyboard(false)
        this.scanGunKeyEventHelper = scanGunKeyEventHelper
    }

    fun setCouponCode(code: String) {
        binding?.etCouponCode?.setText(code)

    }

    override fun onViewCreated(contentView: View) {
        binding = PopupScanCouponBinding.bind(contentView)
        binding?.etCouponCode?.setOnEditorActionListener { v, actionId, event ->
            if (actionId == EditorInfo.IME_ACTION_DONE) {
                val textString = binding?.etCouponCode?.text?.toString()
                if (!TextUtils.isEmpty(textString)) {
                    hideSoftKeyboard(context)
                    scanCouponAction.invoke(textString!!)
                }
            }
            return@setOnEditorActionListener false
        }
        binding?.etCouponCode?.setOnFocusChangeListener { v, hasFocus ->
            if (hasFocus) {
                scanGunKeyEventHelper.setOnBarCodeCatchListener(null)
            } else {
                scanGunKeyEventHelper.setOnBarCodeCatchListener(this)
            }
        }
//        binding?.etCouponCode?.setOnKeyListener { v, keyCode, event ->
//            "${event.action}  $keyCode".dXLog()
//            if (event.action == KeyEvent.ACTION_DOWN && keyCode == KeyEvent.KEYCODE_DEL) {
//                val textString = binding?.etCouponCode?.text?.toString()
//                textString?.dXLog()
//                if (textString!!.isNotEmpty()) {
//                    val newText = textString.substring(0, textString.length)
//                    binding?.etCouponCode?.setText(newText)
//                    binding?.etCouponCode?.setSelection(newText.length)
//                }
//            }
//            return@setOnKeyListener false
//
//        }
    }

    fun setScanCouponClick(scanCouponAction: (couponCode: String) -> Unit) {
        this.scanCouponAction = scanCouponAction
    }

    override fun onScanSuccess(barcode: String) {
        Log.i("barcode", barcode + "")
        if (barcode.isNotEmpty()) {
            binding?.etCouponCode?.setText(barcode)
            scanCouponAction.invoke(barcode)
        }
    }


}