package com.ypsx.yppos.ui.popup

import android.content.Context
import android.view.Gravity
import android.view.View
import android.view.animation.Animation
import com.ypsx.yppos.R
import com.ypsx.yppos.databinding.PopupOfferDetailsBinding
import com.ypsx.yppos.databinding.PopupSettingsBinding
import com.ypsx.yppos.utils.CacheUtil
import com.ypsx.base.util.dXLog
import com.ypsx.yppos.viewmodel.state.OfferDetailsViewModel
import com.ypsx.yppos.viewmodel.state.SettingsViewModel
import razerdp.basepopup.BasePopupWindow
import razerdp.util.animation.AnimationHelper
import razerdp.util.animation.TranslationConfig

/**
 * 优惠详情
 */
class OfferDetailsPopupWindow(context: Context?) : BasePopupWindow(context) {
    private lateinit var bind: PopupOfferDetailsBinding

    init {
        setContentView(R.layout.popup_offer_details)
        setAlignBackgroundGravity(Gravity.BOTTOM)
        setAlignBackground(true)
        setPopupGravity(GravityMode.RELATIVE_TO_ANCHOR, Gravity.TOP)
        "${CacheUtil.getRealName()}查看优惠明细".dXLog()
    }

    override fun onCreateShowAnimation(): Animation {
        return AnimationHelper.asAnimation()
            .withTranslation(TranslationConfig.FROM_BOTTOM)
            .toShow()
    }

    override fun onCreateDismissAnimation(): Animation {
        return AnimationHelper.asAnimation()
            .withTranslation(TranslationConfig.TO_BOTTOM)
            .toDismiss()
    }

    override fun onViewCreated(contentView: View) {
        bind = PopupOfferDetailsBinding.bind(contentView)
        bind.vm = OfferDetailsViewModel()
    }

    fun setData(
        discount: String,
        discountSpecial: String,
        discountMoney: String,
        discountTime: String,
        discountMember: String
    ) {
        bind.vm!!.discount.set("¥$discount")
        bind.vm!!.discountSpecial.set("-¥$discountSpecial")
        bind.vm!!.discountMoney.set("-¥$discountMoney")
        bind.vm!!.discountTime.set("-¥$discountTime")
        bind.vm!!.discountMember.set("-¥$discountMember")
    }

    override fun showPopupWindow() {
        super.showPopupWindow()

    }


}