package com.ypsx.yppos.ui.popup

import android.content.Context
import android.view.Gravity
import android.view.View
import com.ypsx.base.base.appContext
import com.ypsx.base.ext.util.screenWidth
import com.ypsx.yppos.R
import com.ypsx.yppos.databinding.PopupMessageBinding
import com.ypsx.yppos.databinding.PopupMessageTipsBinding
import com.ypsx.yppos.viewmodel.state.MessageTipsViewModel
import com.ypsx.yppos.viewmodel.state.MessageViewModel
import razerdp.basepopup.BasePopupWindow

class MessageTipsPopupWindow(context: Context) : BasePopupWindow(context) {
    var binding: PopupMessageTipsBinding?=null
    init {
        setContentView(R.layout.popup_message_tips)
        width = appContext.screenWidth / 4 * 3
        popupGravity = Gravity.CENTER
        isOutSideTouchable = false
        setOutSideDismiss(false)
        setBackPressEnable(false)
    }

    override fun onViewCreated(contentView: View) {
        binding = PopupMessageTipsBinding.bind(contentView)
        binding?.vm = MessageTipsViewModel()
        binding?.click = ProxyClick()

    }

    fun setData(
        content: String,
        sure: String = "确定",
    ) {
        binding?.apply {
            vm?.content?.set(content)
            vm?.sure?.set(sure)

        }
    }


    inner class ProxyClick {


        fun know() {
            dismiss()
        }
    }
}