package com.ypsx.yppos.ui.popup

import android.content.Context
import android.view.Gravity
import android.view.View
import com.ypsx.base.base.appContext
import com.ypsx.base.ext.util.screenWidth
import com.ypsx.yppos.R
import com.ypsx.yppos.databinding.PopupMessageBinding
import com.ypsx.yppos.http.data.entity.PosPayMethod
import com.ypsx.yppos.viewmodel.state.MessageViewModel
import razerdp.basepopup.BasePopupWindow

class MessagePopupWindow(context: Context) : BasePopupWindow(context) {
     var binding: PopupMessageBinding?=null
    private var messageAction: () -> Unit = { }

    init {
        setContentView(R.layout.popup_message)
        width = appContext.screenWidth / 4 * 3
        popupGravity = Gravity.CENTER
        isOutSideTouchable = false
        setOutSideDismiss(false)
        setBackPressEnable(false)
    }

    override fun onViewCreated(contentView: View) {
        binding = PopupMessageBinding.bind(contentView)
        binding?.vm = MessageViewModel()
        binding?.click = ProxyClick()

    }

    fun setData(
        title: String,
        content: String,
        cancel: String = "取消",
        sure: String = "确定",
        gone: Boolean = true
    ) {
        binding?.apply {
            vm?.title?.set(title)
            vm?.content?.set(content)
            vm?.gone?.set(gone)
            vm?.cancel?.set(cancel)
            vm?.sure?.set(sure)

        }
    }

    inner class ProxyClick {
        fun cancel() {
            dismiss()
        }

        fun sure() {
            messageAction.invoke()
        }
    }

    fun setMessageClick(payAction: () -> Unit) {
        this.messageAction = payAction
    }


}