package com.ypsx.yppos.ui.popup

import android.content.Context
import android.text.TextUtils
import android.view.Gravity
import android.view.View
import com.ypsx.base.base.appContext
import com.ypsx.base.ext.util.screenWidth
import com.ypsx.yppos.R
import com.ypsx.yppos.databinding.PopupMemberRegisterBinding
import com.ypsx.yppos.http.data.entity.AgeGroupEnum
import com.ypsx.yppos.utils.toast
import com.ypsx.yppos.viewmodel.state.MemberRegisterViewModel
import razerdp.basepopup.BasePopupWindow

class MemberRegisterPopupWindow(context: Context?) : BasePopupWindow(context) {
    var binding: PopupMemberRegisterBinding? = null
    private lateinit var mobile: String
    private var registerMemberAction: (mobile: String,gender:Int,ageGroup:String) -> Unit = { mobile, gender, ageGroup -> {} }
    init {
        setContentView(R.layout.popup_member_register)
        width = appContext.screenWidth / 4 * 3
        popupGravity = Gravity.CENTER
        setPriority(Priority.LOW)
        isOutSideTouchable = false
        setOutSideDismiss(false)
        setBackPressEnable(false)
    }

    override fun onViewCreated(contentView: View) {
        binding = PopupMemberRegisterBinding.bind(contentView)
        binding?.vm = MemberRegisterViewModel()
        binding?.click = ProxyClick()
        binding?.tvGender?.keyListener = null
        binding?.tvAge?.keyListener = null

    }

    fun setMobile(mobile: String) {
        this.mobile = mobile
        binding?.vm?.memberMobile?.set(mobile)
    }

    inner class ProxyClick {

        fun chooseGender() {
            val genderChoosePopupWindow = GenderChoosePopupWindow(context)
            genderChoosePopupWindow.showPopupWindow()
            genderChoosePopupWindow.setChooseGenderClick {
                binding?.vm?.memberGenderEnum?.set(it)
                when (it) {
                    1 -> binding?.vm?.memberGender?.set(context.resources.getString(
                        R.string.gender_male
                    ))
                    2 -> binding?.vm?.memberGender?.set(context.resources.getString(
                        R.string.gender_female
                    ))
                    else -> binding?.vm?.memberGender?.set(context.resources.getString(
                        R.string.gender_male
                    ))
                }
            }
        }

        fun chooseAge() {
            val chooseAgeGroupPopupWindow = ChooseAgeGroupPopupWindow(context)
            chooseAgeGroupPopupWindow.showPopupWindow()
            chooseAgeGroupPopupWindow.setChooseAgeGroupClick {
                binding?.vm?.memberAgeEnum?.set(it.name)
                when (it) {
                    AgeGroupEnum.UNDER_30 -> binding?.vm?.memberAge?.set(
                        context.resources.getString(
                            R.string.age_under_30
                        )
                    )
                    AgeGroupEnum.BETWEEN_30_50 -> binding?.vm?.memberAge?.set(
                        context.resources.getString(
                            R.string.age_between_30_50
                        )
                    )
                    AgeGroupEnum.ABOVE_50 -> binding?.vm?.memberAge?.set(
                        context.resources.getString(
                            R.string.age_above_50
                        )
                    )
                }
            }
        }

        fun cancel() {
            dismiss()
        }

        fun sure() {
            val memberGender = binding?.vm?.memberGenderEnum?.get()
            if (memberGender == 0) {
                context.resources.getString(
                    R.string.choose_gender
                ).toast()
                return
            }
            val memberAgeGroup = binding?.vm?.memberAgeEnum?.get()
            if (TextUtils.isEmpty(memberAgeGroup)) {
                context.resources.getString(
                    R.string.choose_age
                ).toast()
                return
            }
            registerMemberAction.invoke(mobile,memberGender!!,memberAgeGroup!!)
        }
    }
    fun setRegisterMemberClick(registerMemberAction: (mobile: String,gender:Int,ageGroup:String) -> Unit) {
        this.registerMemberAction = registerMemberAction
    }
}