package com.ypsx.yppos.ui.popup

import android.content.Context
import android.text.TextUtils
import android.view.Gravity
import android.view.View
import com.ypsx.base.base.appContext
import com.ypsx.base.ext.util.screenWidth
import com.ypsx.base.util.RegexUtils
import com.ypsx.yppos.R
import com.ypsx.yppos.databinding.PopupMemberLoginBinding
import com.ypsx.yppos.databinding.PopupMessageBinding
import com.ypsx.yppos.utils.toast
import com.ypsx.yppos.viewmodel.state.MessageViewModel
import razerdp.basepopup.BasePopupWindow

class MemberLoginPopupWindow(context: Context?) : BasePopupWindow(context) {
    var binding: PopupMemberLoginBinding?=null
    private var memberLoginAction: (phone:String) -> Unit = { }
    init {
        setContentView(R.layout.popup_member_login)
        width = appContext.screenWidth / 4 * 3
        popupGravity = Gravity.CENTER
        isOutSideTouchable = false
        setOutSideDismiss(false)
        setBackPressEnable(false)
    }

    override fun onViewCreated(contentView: View) {
        binding = PopupMemberLoginBinding.bind(contentView)
        binding?.click = ProxyClick()
        setAutoShowKeyboard(binding?.etMemberPhone,true)

    }

    inner class ProxyClick {
        fun cancel() {
            dismiss()
        }

        fun sure() {
            val phone = binding?.etMemberPhone?.text.toString()
            if (TextUtils.isEmpty(phone)) {
                "手机号不能为空！".toast()
                return
            }
            if (!RegexUtils.isMobileSimple(phone)) {
                "手机号不符合规则".toast()
                return
            }
            dismiss()
            memberLoginAction.invoke(phone)
        }
    }

    fun setMemberLoginClick(memberLoginAction: (phone:String) -> Unit) {
        this.memberLoginAction = memberLoginAction
    }
}

