package com.ypsx.yppos.ui.popup

import android.content.Context
import android.view.Gravity
import android.view.View
import com.ypsx.base.base.appContext
import com.ypsx.base.ext.util.screenWidth
import com.ypsx.yppos.R
import com.ypsx.yppos.databinding.PopupGenderChooseBinding
import com.ypsx.yppos.databinding.PopupMemberLoginBinding
import com.ypsx.yppos.databinding.PopupMemberRegisterBinding
import razerdp.basepopup.BasePopupWindow

/**
 * 性别选择
 */
class GenderChoosePopupWindow(context: Context) : BasePopupWindow(context) {
    var binding: PopupGenderChooseBinding?=null
    private var chooseGenderAction: (gender:Int) -> Unit = { }
    init {
        setContentView(R.layout.popup_gender_choose)
        popupGravity = Gravity.BOTTOM
        setPriority(Priority.HIGH)
        setOverlayMask(true)
        isOutSideTouchable = true
        setOutSideDismiss(true)
        setBackPressEnable(false)
    }

    override fun onViewCreated(contentView: View) {
        binding = PopupGenderChooseBinding.bind(contentView)
        binding?.click = ProxyClick()

    }

    inner class ProxyClick {

        fun choose(gender: Int) {
            dismiss()
            chooseGenderAction.invoke(gender)
        }


        fun cancel() {
            dismiss()
        }

    }

    fun setChooseGenderClick(chooseGenderAction: (gender:Int) -> Unit) {
        this.chooseGenderAction = chooseGenderAction
    }
}