package com.ypsx.yppos.ui.popup

import android.content.Context
import android.view.Gravity
import android.view.View
import com.ypsx.yppos.R
import com.ypsx.yppos.databinding.PopupChooseAgeGroupBinding
import com.ypsx.yppos.http.data.entity.AgeGroupEnum
import razerdp.basepopup.BasePopupWindow

class ChooseAgeGroupPopupWindow(context: Context) : BasePopupWindow(context) {
    var binding: PopupChooseAgeGroupBinding? = null
    private var chooseAgeGroupAction: (ageGroup: AgeGroupEnum) -> Unit = { }

    init {
        setContentView(R.layout.popup_choose_age_group)
        popupGravity = Gravity.BOTTOM
        setPriority(Priority.HIGH)
        setOverlayMask(true)
        isOutSideTouchable = true
        setOutSideDismiss(true)
        setBackPressEnable(false)
    }

    override fun onViewCreated(contentView: View) {
        binding = PopupChooseAgeGroupBinding.bind(contentView)
        binding?.click = ProxyClick()

    }

    inner class ProxyClick {

        fun choose(ageGroup: AgeGroupEnum) {
            dismiss()
            chooseAgeGroupAction.invoke(ageGroup)
        }


        fun cancel() {
            dismiss()
        }

    }

    fun setChooseAgeGroupClick(chooseAgeGroupAction: (ageGroup: AgeGroupEnum) -> Unit) {
        this.chooseAgeGroupAction = chooseAgeGroupAction
    }
}