package com.ypsx.yppos.ui.adapter

import android.graphics.Color
import android.text.SpannableString
import android.text.SpannableStringBuilder
import android.text.Spanned
import android.text.style.ImageSpan
import android.widget.TextView
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.ypsx.base.ext.util.dp2px
import com.ypsx.yppos.R
import com.ypsx.yppos.http.data.bean.InsertOrderProductDTO
import com.ypsx.yppos.http.data.entity.PosProductStyle
import com.ypsx.yppos.utils.RoundBackgroundColorSpan
import java.text.DecimalFormat


class OrderProductAdapter(data: ArrayList<InsertOrderProductDTO>) :
    BaseQuickAdapter<InsertOrderProductDTO, BaseViewHolder>(

        R.layout.item_pos_product, data
    ) {
    private var decimalFormat: DecimalFormat = DecimalFormat("###################.###########")
    override fun convert(holder: BaseViewHolder, item: InsertOrderProductDTO) {
        item.run {
            when (style) {
                PosProductStyle.SINGLE.name -> holder.setText(R.id.tv_barCode, "条码：$barCode")
                PosProductStyle.WEIGHT.name -> {
                    if (weightCode.isNullOrEmpty()) {
                        holder.setText(R.id.tv_barCode, "PLU：$mnemonicCode")
                    } else {
                        holder.setText(R.id.tv_barCode, "PLU：$weightCode")
                    }
                }
            }


            if (discountTotal > 0.0 || isPromotion) {
                val ssb = SpannableStringBuilder("促销 $name")
                var roundBackgroundColorSpan =
                    RoundBackgroundColorSpan(
                        14, 8, 2,
                        Color.WHITE,
                        Color.parseColor("#FF4400")
                    )
                ssb.setSpan(roundBackgroundColorSpan, 0, 2, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE)
                holder.setText(R.id.tv_name, ssb)
            } else {
                if (priceType == "MEMBER_TYPE") {
//                    val view = holder.getView<TextView>(R.id.tv_name)
                    var drawable = context.resources.getDrawable(R.drawable.ic_yp_member, null)
                    drawable.setBounds(0, 0, context.dp2px(16), context.dp2px(16))
//                    view.setCompoundDrawables(
//                        drawable,
//                        null, null, null
//                    );
//                    view.compoundDrawablePadding = context.dp2px(5)
                    val ssb = SpannableStringBuilder("1 $name")
                    ssb.setSpan(
                        ImageSpan(drawable),
                        0,
                        1,
                        SpannableString.SPAN_EXCLUSIVE_EXCLUSIVE
                    )
                    holder.setText(R.id.tv_name, ssb)
                } else {
                    holder.setText(R.id.tv_name, name)
                }
            }
            holder.setText(R.id.tv_price, "¥$price/$unit")
            holder.setText(R.id.tv_amount, "$amount")
            when (style) {
                PosProductStyle.SINGLE.name -> {
                    holder.setGone(R.id.ll_count, false)
                    holder.setGone(R.id.tv_weight, true)
                    holder.setText(R.id.tv_count, "${quantity.toInt()}")
                }
                PosProductStyle.WEIGHT.name -> {
                    holder.setGone(R.id.ll_count, false)
                    holder.setGone(R.id.tv_weight, true)
                    holder.setText(R.id.tv_count, decimalFormat.format(quantity))
                }
                else -> {

                }
            }
        }
    }

}