package com.ypsx.yppos.room.entity

import androidx.room.Entity
import androidx.room.Index
import androidx.room.PrimaryKey

@Entity(tableName = "POS_Product")
data class PosProduct(
    @PrimaryKey
    var id: String,
    var barCode: String,
    var productNumber: String,
    var sellPrice: Double = 0.00,
    var balance: Double = 0.00,
    //POS门店商品状态
    var shelvesStatus: String,
    var name: String = "",
    var status: String? = null,
    //是否是虚拟产品
    var isVirtual: Boolean = false,
    var style: String,
    //单位
    var unit: String,
    var spec: String,
    var storeId: String = "",
    var pluLevel: String = "",
    //换算比例
    var conversionRatio: String? = null,
    var merchantItemId: String? = null,
    var mnemonicCode: String = ""


)
