package com.ypsx.yppos.room.entity

import androidx.room.Entity
import androidx.room.PrimaryKey

@Entity(tableName = "POS_Config")
data class PosConfig(
    @PrimaryKey
    var id: String,
    var posId: String? =null,
    var brand: String,
    var code: String?=null,
    var createTime: String,
    var creatorId: String,
    var creatorName: String,
    var specification:String,
    var installDiskCapacity: String,
    var installationDirectory: String,
    var ip: String,
    var macAddress: String,
    var orgId: String,
    var remark: String? = null,
    var storeId: String?=null,
    var storeName: String? =null,
    var port: Int,
    var status:String,
    var version:String,

    //二维码前链接
    var einvoiceQrcodeUrlPrefix:String? =null,
    var storeClerkRoleName:String?=null,
    var storeManagerRoleName:String?=null,
    var isAutoOpen:Boolean=false,
    var posCode:String?=null,
    var lastestPartUpdateTime:String?=null,
    var ZTposId:Int =0,
    //删除挂单 0:全部允许 1:需店长授权
    var deleteList:Int =0,
//整单取消授权方式: 0: 全部允许， 1：需店长授权
    var cancelWholeOrder: Int =0,
    //现金圆整方式: 0: 四舍五入,1:舍分
    var cashRoundMode: Int=0,
    //锁屏时间，单位分钟, =0表示不锁屏，大于0表示锁屏时间(限制5-60)
    var lockScreen: Int=0,
    //最大挂单数: 限制0-5
    var maxPendingOrder: Int=0,
    var payMethods: String?=null,
    //是否打印小票条码
    var printTicketBar: Boolean = false,
    //是否打印电子发票
    var printTicketQrcode: Boolean =false,
    var printTicketQrcodePrompt: String?=null,
    //小票底部文字
    var ticketBottom:String? =null,



)
