package com.ypsx.yppos.room.entity

import androidx.room.*
import androidx.room.ForeignKey.CASCADE

/**
 * 付款方式
 */
@Entity(
    tableName = "POS_BuyPayment",
    indices=[Index(value = ["id","orderId"])],
    foreignKeys = [ForeignKey(
        entity = PosBuy::class,
        parentColumns = ["id"],
        childColumns = ["orderId"],
        onDelete = CASCADE
    )]
)
data class PosBuyPayment(
    @PrimaryKey
    var id: String,
    @ColumnInfo(index = true)
    var orderId: String,


    var payMethod: String,
    var payTime: String,
    var total: Double = 0.00,
    var payCode: String? = null,
    //支付方式
    var realPayMethod: String? = null,
    var realPayFlowNo: String? = null,
    var payFlowNo: String,

    var status: String,
//    var openId: String,
    var openId: String? = null,

    )
