package com.ypsx.yppos.room.entity

import androidx.room.*

/**
 * 付款商品，包含删除商品
 */
@Entity(
    tableName = "POS_BuyPart", indices=[Index(value = ["id","orderId"])], foreignKeys = [ForeignKey(
        entity = PosBuy::class,
        parentColumns = ["id"],
        childColumns = ["orderId"],
        onDelete = ForeignKey.CASCADE
    )]
)
data class PosBuyPart(
    @PrimaryKey
    var id: String,

    var productId: String,
    @ColumnInfo(index = true)
    var orderId: String,
    var quantity: Double = 0.00,
    var tailAmount: Int = 0,
    var amount: Double = 0.0,
    var weightCode: String? = null,
    //是否是删除项
    var deleted: Boolean,
    var conversionRatio: String? = null,
    var name: String,
    var spec: String,
    var unit: String,
    var productNumber: String,
    var eaQty: Int,
    var barCode: String,
    var isVirtual: Boolean,
    var activitys: String? = null,
    var cardNumber: String? = null,
    var style: String? = null,
    var pluLevel: String? = null,
    var activityType: String? = null,
    var priceType: String,

    var payApportionAmount: Double = 0.00,
    var activityPrice: Double = 0.00,
    var price: Double = 0.00,
    var memberPrice:Double =0.00,
    var settlementPrice: Double = 0.00,
    var discountTotal: Double = 0.00,
    var discountPrice: Double = 0.00,
)
