package com.ypsx.yppos

import android.os.Build
import android.os.Bundle
import com.hjq.toast.ToastUtils
import com.uc.crashsdk.export.CrashApi
import com.umeng.analytics.MobclickAgent
import com.umeng.commonsdk.UMConfigure
import com.ypsx.base.base.BaseApp
import com.ypsx.base.util.dXLog
import com.ypsx.common.app.event.AppViewModel
import com.ypsx.common.app.event.EventViewModel
import com.ypsx.yppos.room.database.PosDatabase


class PosApp : BaseApp() {

    companion object {
        lateinit var instance: PosApp
        lateinit var eventViewModelInstance: EventViewModel
        lateinit var appViewModelInstance: AppViewModel
    }

    override fun onCreate() {
        super.onCreate()
        // 初始化 Toast 框架
        ToastUtils.init(this);

        instance = this
        PosDatabase.getDatabase(instance)
        eventViewModelInstance = getAppViewModelProvider().get(EventViewModel::class.java)
        appViewModelInstance = getAppViewModelProvider().get(AppViewModel::class.java)
        initXlog()
        UMConfigure.setLogEnabled(false);
        //初始化组件化基础库, 所有友盟业务SDK都必须调用此初始化接口。
        UMConfigure.init(
            this,
            "61c283dce0f9bb492ba44479",
            "yp_pos",
            UMConfigure.DEVICE_TYPE_PHONE,
            ""
        );
        // 选用AUTO页面采集模式
        MobclickAgent.setPageCollectionMode(MobclickAgent.PageMode.AUTO)

        val customInfo = Bundle()
        customInfo.putBoolean("mCallNativeDefaultHandler", true)
        CrashApi.getInstance().updateCustomInfo(customInfo)

    }

    private fun initXlog() {
        val header = "\n>>>>>>>>>>>>>>>> File Header >>>>>>>>>>>>>>>>" +
                "\nDevice Manufacturer: " + Build.MANUFACTURER +
                "\nDevice Brand       : " + Build.BRAND +
                "\nDevice Model       : " + Build.MODEL +
                "\nAndroid Version    : " + Build.VERSION.RELEASE +
                "\nAndroid SDK        : " + Build.VERSION.SDK_INT +
                "\nApp VersionName    : " + BuildConfig.VERSION_NAME +
                "\nApp VersionCode    : " + BuildConfig.VERSION_CODE +
                "\n<<<<<<<<<<<<<<<< File Header <<<<<<<<<<<<<<<<\n\n";
        header.dXLog()

    }


}