package com.ypsx.base.util

import android.os.Build
import com.ypsx.base.base.appContext

object AppUtils {

    fun getAppVersionName(): String {
        val packageName = appContext.packageName

        //获取当前版本号
        return try {
            appContext.packageManager.getPackageInfo(packageName, 0).versionName
        } catch (e: Exception) {
            "1.0.0"
        }
    }

    fun getVersionCode(): Long {
        val packageName = appContext.packageName

        //获取当前版本号
        return try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P) {
                appContext.packageManager.getPackageInfo(packageName, 0).longVersionCode
            } else {
                appContext.packageManager.getPackageInfo(packageName, 0).versionCode.toLong()
            }
        } catch (e: Exception) {
            0
        }
    }

    /**
     * 获取称重设备Sn码
     *
     * @return
     */
    fun getSnCode(): String? {
        return when {
            Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q -> {
                ""
            }
            Build.VERSION.SDK_INT < Build.VERSION_CODES.O -> {
                Build.SERIAL
            }
            else -> {
                Build.getSerial()
            }
        }
    }
}