package com.ypsx.yppos.viewmodel.request

import androidx.lifecycle.MutableLiveData
import com.ypsx.base.base.viewmodel.BaseViewModel
import com.ypsx.base.ext.launch
import com.ypsx.base.ext.request
import com.ypsx.base.ext.util.loge
import com.ypsx.base.util.dXLog
import com.ypsx.base.util.eXLog
import com.ypsx.yppos.http.apiService
import com.ypsx.yppos.http.data.bean.PosMachineResponse
import com.ypsx.yppos.http.repository.request.HttpRequestCoroutine
import com.ypsx.yppos.room.repository.PosConfigRepository
import com.ypsx.yppos.utils.toast

class RequestSplashViewModel : BaseViewModel() {
    var posDetails = MutableLiveData<PosMachineResponse>()
    var posDetails2 = MutableLiveData<PosMachineResponse>()

    fun getById(id: String) {
        request({ apiService.getById(id) }, {
            posDetails.postValue(it)
        }, {
            it.errorMsg.loge()
            it.errorMsg.toast()
        }, true)
    }



    fun savePosConfig(posMachineResponse: PosMachineResponse) {
        launch({ PosConfigRepository.getInstance().savePosDetail(posMachineResponse) }, {
            "保存数据库PosConfig成功".dXLog()
        }, {
            "保存数据库PosConfig失败".eXLog()
        })
    }
}