package com.ypsx.yppos.utils

import android.text.TextUtils
import com.alibaba.sdk.android.oss.ClientConfiguration
import com.alibaba.sdk.android.oss.ClientException
import com.alibaba.sdk.android.oss.OSSClient
import com.alibaba.sdk.android.oss.ServiceException
import com.alibaba.sdk.android.oss.common.OSSLog
import com.alibaba.sdk.android.oss.common.auth.OSSCredentialProvider
import com.alibaba.sdk.android.oss.common.auth.OSSPlainTextAKSKCredentialProvider
import com.alibaba.sdk.android.oss.model.PutObjectRequest
import com.alibaba.sdk.android.oss.model.PutObjectResult
import com.ypsx.base.base.appContext
import com.ypsx.base.ext.util.toJson
import java.util.*

class OSSClientUtil {

    private var ossClient: OSSClient? = null


    companion object {
        private var instance: OSSClientUtil? = null

        fun getInstance(): OSSClientUtil {
            if (instance == null) {
                instance = OSSClientUtil()
            }
            return instance!!
        }
    }

    /**
     * 清空客户端缓存。
     *
     * <br></br>
     * 一般在用户注销时， 执行。
     */
    fun clear() {
        ossClient = null
    }

    /**
     * 配置客户端。
     */
    private fun ensureConfig() {
        if (ossClient == null) {
            val credentialProvider: OSSCredentialProvider = OSSPlainTextAKSKCredentialProvider(
                CacheUtil.getAliYunKey(dfs_aliyunAccessKeyId),
                CacheUtil.getAliYunKey(dfs_aliyunAccessKeySecret)
            )
            val conf = ClientConfiguration()
            conf.connectionTimeout = 60 * 1000 // 连接超时，默认15秒
            conf.socketTimeout = 60 * 1000 // socket超时，默认15秒
            conf.maxConcurrentRequest = 1 // 最大并发请求书，默认5个
            conf.maxErrorRetry = 2 // 失败后最大重试次数，默认2次
            OSSLog.enableLog()
            ossClient = OSSClient(
                appContext,
                CacheUtil.getAliYunKey(dfs_aliyunEndPoint), credentialProvider, conf
            )
        }
    }

    /**
     * 上传文件。
     *
     * @param objectKey
     * @param localFilePath
     * @return
     * @throws ClientException
     * @throws ServiceException
     */
    @Throws(ClientException::class, ServiceException::class)
    fun upload(objectKey: String?, localFilePath: String?): PutObjectResult? {
        ensureConfig()
        val put =
            PutObjectRequest(CacheUtil.getAliYunKey(dfs_aliyunBucketName), objectKey, localFilePath)
        return ossClient!!.putObject(put)
//        return null
    }

    fun getObjectKey(localurl: String): String? {
        if (TextUtils.isEmpty(localurl)) {
            return null
        }
        val deviceId: String = UUID.randomUUID().toString().replace("-", "")
        if (TextUtils.isEmpty(deviceId)) {
            return null
        }
        val strArray = localurl.split("/").toTypedArray()
        val name = strArray[strArray.size - 1]
        return "ypsx-pos/log/$deviceId/$name"
    }


    /**
     * 访问OSS文件的基准地址。
     *
     * @return
     */
    fun getBaseUrl(): String {
        return CacheUtil.getAliYunKey(dfs_aliyunDomain)!!+"/"
    }


}