package com.ypsx.yppos.ui.popup

import android.content.Context
import android.view.Gravity
import android.view.View
import android.view.animation.Animation
import com.ypsx.base.base.appContext
import com.ypsx.base.ext.util.screenWidth
import com.ypsx.base.util.dXLog
import com.ypsx.yppos.R
import com.ypsx.common.app.ext.startKtxActivityFinish
import com.ypsx.yppos.databinding.PopupSettingsBinding
import com.ypsx.yppos.http.apiService
import com.ypsx.yppos.room.repository.PosBuyRepository
import com.ypsx.yppos.room.repository.PosConfigRepository
import com.ypsx.yppos.ui.activity.LoginActivity
import com.ypsx.yppos.ui.activity.MainActivity
import com.ypsx.yppos.utils.*
import com.ypsx.yppos.viewmodel.state.SettingsViewModel
import kotlinx.coroutines.*
import razerdp.basepopup.BasePopupWindow
import razerdp.util.animation.AnimationHelper
import razerdp.util.animation.TranslationConfig

class SettingsPopupWindow(context: Context?) : BasePopupWindow(context) {
    private lateinit var bind: PopupSettingsBinding
    private val scope = MainScope()

    init {
        setContentView(R.layout.popup_settings)
        width = appContext.screenWidth / 2
        setBackPressEnable(true)
        offsetX = dipToPx(30F).toInt()
        offsetY = dipToPx(-5F).toInt()

        setPopupGravity(GravityMode.RELATIVE_TO_ANCHOR, Gravity.BOTTOM)
    }

    override fun onViewCreated(contentView: View) {
        bind = PopupSettingsBinding.bind(contentView)
        bind.vm = SettingsViewModel()
        bind.click = ProxyClick()
    }

    override fun onCreateShowAnimation(): Animation {
        return AnimationHelper.asAnimation()
            .withTranslation(TranslationConfig.FROM_TOP)
            .toShow()
    }

    override fun onCreateDismissAnimation(): Animation {
        return AnimationHelper.asAnimation()
            .withTranslation(TranslationConfig.TO_TOP)
            .toDismiss()
    }

    inner class ProxyClick {
        fun print() {
            dismiss()
            "${CacheUtil.getRealName()}打印最后一条付款成功记录".dXLog()
            scope.launch {
                kotlin.runCatching {
                    withContext(Dispatchers.IO) {

                        val posConfig = PosConfigRepository.getInstance().loadConfig()
                        val posBuy = PosBuyRepository.getInstance().query()
                        if (posBuy == null || posConfig == null) {
                            "无记录,无法打印".toastSign()
                        } else {
                            val posBuyParts =
                                PosBuyRepository.getInstance().queryPosBuyPartByOrderNo(posBuy.id)
                            posBuyParts.toString().dXLog()
                            val posBuyPayment =
                                PosBuyRepository.getInstance()
                                    .queryPosBuyPaymentByOrderNo(posBuy.id)
                            posBuyPayment.toString().dXLog()
                            PrintUtils.printLast(posConfig, posBuyPayment, posBuy, posBuyParts)
                        }
                    }
                }.onSuccess {
                    "打印完成".toastSuccess()
                }.onFailure {
                }
            }
        }

        fun logout() {
            dismiss()
            val messagePopupWindow = MessagePopupWindow(context)
            messagePopupWindow.showPopupWindow()
            messagePopupWindow.setData(
                "退出登录",
                "是否确定退出登录",
                cancel = "取消",
                sure = "确定",
                true
            )
            messagePopupWindow.setMessageClick {
                scope.launch {
                    kotlin.runCatching {
                        withContext(Dispatchers.IO) {
                            apiService.posLogout()
                        }
                    }.onSuccess {
                        if (it.isSuccess()) {
                            messagePopupWindow.dismiss()
                            "${CacheUtil.getRealName()}主动退出主界面".dXLog()
                            val mainActivity =
                                this@SettingsPopupWindow.context as MainActivity
                            mainActivity.startKtxActivityFinish<LoginActivity>()
                        } else {
                            it.message.toast()
                        }
                    }.onFailure {
                    }

                }
            }
        }
    }


}