package com.ypsx.yppos.ui.popup

import android.content.Context
import android.view.Gravity
import android.view.View
import com.ypsx.base.base.appContext
import com.ypsx.base.ext.util.screenWidth
import com.ypsx.yppos.R
import com.ypsx.yppos.databinding.PopupPayFailedBinding
import com.ypsx.yppos.viewmodel.state.PayFailedViewModel
import razerdp.basepopup.BasePopupWindow

class PayFailedPopWindow(context: Context?) : BasePopupWindow(context) {
    var bind: PopupPayFailedBinding? = null
    var onPayFailedClick: OnPayFailedClick? =null


    init {
        setContentView(R.layout.popup_pay_failed)
        width = appContext.screenWidth / 4 * 3
        popupGravity = Gravity.CENTER
        isOutSideTouchable = false
        setOutSideDismiss(false)
    }

    override fun onViewCreated(contentView: View) {
        bind = PopupPayFailedBinding.bind(contentView)
        bind?.vm = PayFailedViewModel()
        bind?.click = ProxyClick()
    }

    fun setData(message: String) {
        bind?.vm?.failedMessage?.set(message)
    }

    @JvmName("setOnPayFailedClick1")
    fun setOnPayFailedClick(onPayFailedClick: OnPayFailedClick) {
        this.onPayFailedClick = onPayFailedClick
    }


    inner class ProxyClick {
        fun back() {
            dismiss()
            onPayFailedClick?.back()
        }

        fun payAgain() {
            dismiss()
            onPayFailedClick?.payAgain()

        }

    }


}

interface OnPayFailedClick{
    fun back()

    fun payAgain()
}