package com.ypsx.yppos.ui.popup

import android.content.Context
import android.view.Gravity
import android.view.View
import android.view.animation.Animation
import com.ypsx.yppos.R
import com.ypsx.yppos.databinding.PopupOrderPayAmountBinding
import com.ypsx.yppos.http.data.entity.PosPayMethod
import com.ypsx.yppos.room.entity.PosConfig
import com.ypsx.yppos.utils.CacheUtil
import com.ypsx.base.util.dXLog
import com.ypsx.yppos.viewmodel.state.OrderPayAmountViewModel
import razerdp.basepopup.BasePopupWindow
import razerdp.util.animation.AnimationHelper
import razerdp.util.animation.TranslationConfig

class OrderPayAmountPopupWindow(context: Context) : BasePopupWindow(context) {
    var bind: PopupOrderPayAmountBinding? = null
    var posConfig: PosConfig? = null
    var realName = CacheUtil.getRealName()
    private var payAction: (item: PosPayMethod) -> Unit =
        { _: PosPayMethod -> }

    init {
        setContentView(R.layout.popup_order_pay_amount)
        setAlignBackgroundGravity(Gravity.BOTTOM)
        "${realName}选择结算".dXLog()
    }

    override fun onViewCreated(contentView: View) {
        bind = PopupOrderPayAmountBinding.bind(contentView)
        bind?.vm = OrderPayAmountViewModel()
        bind?.click = ProxyClick()

//        val offline: Boolean = bind?.vm?.scanOffline?.get() == false
//        val cardPay: Boolean = bind?.vm?.scanCardPay?.get() == false
//        val cashPay: Boolean = bind?.vm?.scanCashPay?.get() == false
        when (bind?.vm?.firstName?.get()) {
            PosPayMethod.CCB_BAR_PAY.name,
            PosPayMethod.LCSW_BAR_PAY.name -> {
                bind?.rbOffline?.isChecked = true
                bind?.rbCardPay?.isChecked = false
                bind?.rbCash?.isChecked = false

            }
            PosPayMethod.CARDPAY.name -> {
                bind?.rbOffline?.isChecked = false
                bind?.rbCardPay?.isChecked = true
                bind?.rbCash?.isChecked = false
            }
            PosPayMethod.CASHPAY.name -> {
                bind?.rbOffline?.isChecked = false
                bind?.rbCardPay?.isChecked = false
                bind?.rbCash?.isChecked = true
            }
        }

    }

    override fun onCreateShowAnimation(): Animation {
        return AnimationHelper.asAnimation()
            .withTranslation(TranslationConfig.FROM_BOTTOM)
            .toShow()
    }

    override fun onCreateDismissAnimation(): Animation {
        return AnimationHelper.asAnimation()
            .withTranslation(TranslationConfig.TO_BOTTOM)
            .toDismiss()
    }

    fun setData(orderNo: String, amount: String) {
        bind?.vm?.orderNo?.set(orderNo)
        bind?.vm?.payAmount?.set(amount)
    }

    fun setPayClick(payAction: (item: PosPayMethod) -> Unit) {
        this.payAction = payAction
    }

    inner class ProxyClick {
        fun close() {
            dismiss()
        }

        fun pay() {
            var checkedRadioButtonId = bind?.radio?.checkedRadioButtonId
            val payMethod = when (checkedRadioButtonId) {
                R.id.rb_offline -> {
                    val payName = bind!!.vm?.payName?.get()
                    if (payName!!.isNotEmpty()) {
                        when (payName) {
                            PosPayMethod.CCB_BAR_PAY.name -> {
                                PosPayMethod.CCB_BAR_PAY
                            }
                            PosPayMethod.LCSW_BAR_PAY.name -> {
                                PosPayMethod.LCSW_BAR_PAY
                            }
                            else -> {
                                PosPayMethod.CCB_BAR_PAY
                            }
                        }
                    } else {
                        PosPayMethod.CCB_BAR_PAY
                    }

                }
                R.id.rb_cash->PosPayMethod.CASHPAY
                R.id.rbCardPay -> PosPayMethod.CARDPAY
                else -> PosPayMethod.CCB_BAR_PAY
            }
            "${realName}选择${payMethod.name}支付".dXLog()
            payAction.invoke(payMethod)
        }
    }


}