package com.ypsx.yppos.ui.activity

import android.os.Bundle
import android.text.method.HideReturnsTransformationMethod
import android.text.method.PasswordTransformationMethod
import androidx.activity.viewModels
import com.afollestad.materialdialogs.MaterialDialog
import com.afollestad.materialdialogs.list.SingleChoiceListener
import com.afollestad.materialdialogs.list.listItemsSingleChoice
import com.ypsx.base.ext.view.afterTextChange
import com.ypsx.base.ext.view.textStringTrim
import com.ypsx.base.network.manager.NetState
import com.ypsx.base.util.RegexUtils
import com.ypsx.yppos.PosApp
import com.ypsx.yppos.R
import com.ypsx.yppos.databinding.ActivityLoginBinding
import com.ypsx.yppos.room.database.PosDatabase
import com.ypsx.yppos.ui.popup.AppUpdaterPopupWindow
import com.ypsx.yppos.ui.popup.MessagePopupWindow
import com.ypsx.yppos.utils.CacheUtil
import com.ypsx.base.util.dXLog
import com.ypsx.common.app.base.BaseActivity
import com.ypsx.common.app.ext.showServerHostExt
import com.ypsx.common.app.ext.startKtxActivityFinish
import com.ypsx.yppos.utils.toast
import com.ypsx.yppos.viewmodel.request.RequestLoginViewModel
import com.ypsx.yppos.viewmodel.state.LoginViewModel

/**
 * 登录页
 */
class LoginActivity : BaseActivity<LoginViewModel, ActivityLoginBinding>() {
    private val requestLoginViewModel: RequestLoginViewModel by viewModels()

    override fun layoutId(): Int = R.layout.activity_login


    override fun initView(savedInstanceState: Bundle?) {
        mDatabind.vm = mViewModel
        mDatabind.click = ProxyClick()

        mDatabind.etAccount.afterTextChange {
            val a = it.isNotEmpty() && RegexUtils.isMobileSimple(it)
            val password = mDatabind.etPassword.textStringTrim()
            val b = password.isNotEmpty() && password.length >= 6
            if (a && b) {
                mViewModel.enabledStatus.set(true)
            } else {
                mViewModel.enabledStatus.set(false)
            }
        }
        mDatabind.etPassword.afterTextChange {
            val b = it.isNotEmpty() && it.length >= 6
            val username = mDatabind.etAccount.textStringTrim()
            val a = username.isNotEmpty() && RegexUtils.isMobileSimple(username)
            if (a && b) {
                mViewModel.enabledStatus.set(true)
            } else {
                mViewModel.enabledStatus.set(false)
            }
        }
        CacheUtil.getAliYunKey().dXLog()

        requestLoginViewModel.upgradeApk(mViewModel.posId.get())

    }


    inner class ProxyClick {
        fun login() {
            val username = mDatabind.etAccount.textStringTrim()
            val password = mDatabind.etPassword.textStringTrim()
            showLoading(getString(R.string.loading))
            requestLoginViewModel.login(username, password)
        }

        fun eye() {
            val isHideFirst = mViewModel.isHideFirst.get()
            if (isHideFirst) {
                mViewModel.isHideFirst.set(false)
                mDatabind.btEye.setImageResource(R.drawable.ic_eye_open)
                //显示
                mDatabind.etPassword.transformationMethod =
                    HideReturnsTransformationMethod.getInstance()
                mDatabind.etPassword.setSelection(mDatabind.etPassword.textStringTrim().length)

            } else {
                mViewModel.isHideFirst.set(true)
                mDatabind.etPassword.transformationMethod =
                    PasswordTransformationMethod.getInstance()
                mDatabind.btEye.setImageResource(R.drawable.ic_eye_close)
                mDatabind.etPassword.setSelection(mDatabind.etPassword.textStringTrim().length)
            }
        }


        fun combosClick() {
            showServerHostExt(CacheUtil.getHost()) {
                CacheUtil.setHost(it)
                CacheUtil.clearAll()
                PosDatabase.clearAllTables()
                PosApp.instance.restartApplication()
            }

        }
    }



    override fun createObserver() {
        requestLoginViewModel.posDetails.observe(this, {
            dismissLoading()
            if (it.isSuccess) {
                startKtxActivityFinish<MainActivity>()
            }
        })
        requestLoginViewModel.posDetails2.observe(this, {
            dismissLoading()
            if (!it.isSuccess) {
                val messagePopupWindow = MessagePopupWindow(this)
                messagePopupWindow.showPopupWindow()
                messagePopupWindow.setData("提示", it.errorMsg, "取消", "确定")
                messagePopupWindow.setMessageClick {
                    messagePopupWindow.dismiss()
                    val username = mDatabind.etAccount.textStringTrim()
                    showLoading(getString(R.string.loading))
                    requestLoginViewModel.posKickOff(username)
                }
            } else {
                it.errorMsg.toast()
            }
        })
        requestLoginViewModel.appVersion.observe(this, {
            val appUpdaterPopupWindow = AppUpdaterPopupWindow(this)
            appUpdaterPopupWindow.showPopupWindow()
            appUpdaterPopupWindow.setData(it)
        })

    }

    override fun onNetworkStateChanged(netState: NetState) {
        if (netState.isSuccess) {
            "我特么终于有网了啊!".dXLog()
        } else {
            "我特么怎么断网了!".dXLog()
        }
    }
}