package com.ypsx.yppos.room.repository

import com.ypsx.base.base.appContext
import com.ypsx.yppos.room.dao.PosConfigDao
import com.ypsx.yppos.room.dao.PosProductDao
import com.ypsx.yppos.room.database.PosDatabase
import com.ypsx.yppos.room.entity.PosProduct
import com.ypsx.base.util.dXLog

class PosProductRepository {

    companion object {
        private val instance: PosProductRepository = PosProductRepository()

        fun getInstance(): PosProductRepository {
            return instance
        }
    }

    private fun getPosProductDao(): PosProductDao {
        return PosDatabase.getDatabase(appContext).posProductDao()
    }


    fun insertAll(posProduct: List<PosProduct>) {
        "插入数据${posProduct.size}".dXLog()
        getPosProductDao().insertList(posProduct)
    }


    fun queryKeyWords(key: String): PosProduct? {
        return getPosProductDao().queryKeyWords(key)
    }

    fun queryByMnemonicCode(mnemonicCode:String):PosProduct?{
        return getPosProductDao().queryByMnemonicCode(mnemonicCode)
    }

    fun queryId(key: String): String? {
        return getPosProductDao().queryKeyWords2(key)
    }

    fun queryAllIn( productIds: ArrayList<String>):List<PosProduct> {
        productIds.toArray().contentToString().dXLog()
        return getPosProductDao().queryAllByProductId(productIds)
    }
}