package com.ypsx.yppos.room.dao

import androidx.room.*
import com.ypsx.yppos.room.entity.PosConfig

@Dao
interface PosConfigDao {
    @Query("SELECT * from POS_Config LIMIT 0,1")
    fun loadConfig(): PosConfig?

    @Query("SELECT * from POS_Config where id=:id LIMIT 0,1")
    fun loadConfig(id:String): PosConfig?

    @Query("DELETE FROM POS_Config")
    fun deleteAll()

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun insert(posConfig: PosConfig)

    @Update
    fun update(posConfig: PosConfig)
}