package com.ypsx.yppos.http

import com.ypsx.base.util.DeviceUtils
import com.ypsx.yppos.utils.CacheUtil
import okhttp3.Interceptor
import okhttp3.Response
import java.io.IOException

/**
 * 自定义头部参数拦截器，传入heads
 */
class HeadInterceptor : Interceptor {

    @Throws(IOException::class)
    override fun intercept(chain: Interceptor.Chain): Response {
        val builder = chain.request().newBuilder()
        builder.addHeader("Content-Type", "application/json;charset=utf-8").build()
        builder .addHeader("Accept", "application/json;charset=utf-8").build()
        val loginResponse = CacheUtil.getLoginResponse()
        if (loginResponse != null && loginResponse.accessToken.isNotEmpty()) {
            builder.addHeader("access-token", loginResponse.accessToken).build()
        }
        builder.addHeader("device", "Android").build()
        builder.addHeader("mac-addr", DeviceUtils.getMacAddress()).build()
        return chain.proceed(builder.build())
    }

}