package com.ypsx.yppos

import android.os.Build
import com.hjq.toast.ToastUtils
import com.ypsx.base.base.BaseApp
import com.ypsx.base.util.dXLog
import com.ypsx.common.app.event.AppViewModel
import com.ypsx.common.app.event.EventViewModel
import com.ypsx.yppos.room.database.PosDatabase


class PosApp : BaseApp() {

    companion object {
        lateinit var instance: PosApp
        lateinit var eventViewModelInstance: EventViewModel
        lateinit var appViewModelInstance: AppViewModel
    }

    override fun onCreate() {
        super.onCreate()
        // 初始化 Toast 框架
        ToastUtils.init(this);

        instance = this
        PosDatabase.getDatabase(instance)
        eventViewModelInstance = getAppViewModelProvider().get(EventViewModel::class.java)
        appViewModelInstance = getAppViewModelProvider().get(AppViewModel::class.java)
        initXlog()


    }

    private fun initXlog() {
        val header = "\n>>>>>>>>>>>>>>>> File Header >>>>>>>>>>>>>>>>" +
                "\nDevice Manufacturer: " + Build.MANUFACTURER +
                "\nDevice Brand       : " + Build.BRAND +
                "\nDevice Model       : " + Build.MODEL +
                "\nAndroid Version    : " + Build.VERSION.RELEASE +
                "\nAndroid SDK        : " + Build.VERSION.SDK_INT +
                "\nApp VersionName    : " + BuildConfig.VERSION_NAME +
                "\nApp VersionCode    : " + BuildConfig.VERSION_CODE +
                "\n<<<<<<<<<<<<<<<< File Header <<<<<<<<<<<<<<<<\n\n";
       header.dXLog()

    }






}