import { createApp } from 'vue'
import App from './App.vue'
import './index.css'
import './styles/index.scss' // global css
import router from './router'
import 'amfe-flexible'
import i18n from './lang/i18n.js'

const app = createApp(App); // 挂载

import axios from 'axios';
// axios.defaults.baseURL = config.api_url; // 设置了主域名则接口就不需要+了
axios.defaults.withCredentials = false; // 跨域设置，false忽略跨域cookies（Access-Control-Allow-Headers:*）

app.use(router)
app.use(i18n)
app.mount('#app')
