import {
  defineConfig
} from 'vite'
import vue from '@vitejs/plugin-vue'
import postcss100vhFix from 'postcss-100vh-fix'
import postCssPxToRem from 'postcss-pxtorem'

const config = require('./config')

// https://vitejs.dev/config/
export default defineConfig({
  envDir: "./",
  outDir: config.outDir,
  plugins: [vue()],
  css: {
    postcss: {
      plugins: [
        postcss100vhFix,
        postCssPxToRem({
          rootValue: 37.5, // 1rem 的大小
          propList: ['*'], // 需要转换的属性，*(全部转换)
          selectorBlackList: ['pc'],
          unitPrecision: 6 // 转换精度，保留的小数位数
        })
      ]
    }
  },
  base: config.base,
  resolve: config.resolve,
  server: {
    proxy: config.proxy,
    port: config.port
  },
})