import {
  createRouter,
  createWebHistory,
  createWebHashHistory
} from 'vue-router'

// 开启历史模式
// vue2中使用 mode: history 实现
// const routerHistory = createWebHistory("/sdk/");
const routerHashHistory = createWebHashHistory()
const router = createRouter({
  history: routerHashHistory,
  routes: [{
    path: '/',
    component: () => import('../views/startIndex.vue')
  }, {
    path: '/introduce',
    component: () => import('../views/index.vue')
  },
  {
    path: '/complete',
    component: () => import('../views/complete.vue')
  }
  ]
})

export default router