const path = require('path')

module.exports = {
  /**
   * 在生产中服务时的基本公共路径。
   * @default '/'
   */
  base: './',

  /**
   * 与“根”相关的目录
   * @default 'dist'
   */
  outDir: 'dist',
  port: 9528,
  // 是否自动在浏览器打开
  open: true,
  // 是否开启 https
  https: false,
  // 服务端渲染
  ssr: false,
  // 引入第三方的配置
  optimizeDeps: {
    include: ["axios"]
  },
  resolve: {
    alias: {
      '@': path.resolve(__dirname, '../src')
    },
  },
  proxy: {
    '/byte-sdk-api/': {
      target: 'https://bfai-service-apac-uat.d-lab-services.danone.com', // 后端服务实际地址
      changeOrigin: true,
      rewrite: path => path.replace(/^\/ar/, '')
    }
  }
};