/**
 * 用户相关接口
 */
import request from '@/api/request'
import { useAuthStore } from '@/stores/state'
import { saveTokens } from '@/utils/token'

export default {
  // 登录
  login(postData: Wm.LoginParams) {
    return new Promise((resolve, reject) => {
      request
        .post('/user/login', postData)
        .then((res: any) => {
          const authStore = useAuthStore()
          authStore.login()
          saveTokens(res.access_token, res.refresh_token)
          resolve(res)
        })
        .catch((err: any) => {
          reject(err)
        })
    })
  },
  // 注册
  register(postData: Wm.RegisterParams) {
    return request.post('/user/login', postData)
  }
}
