/**
 * 相关接口
 */
import request from '@/api/request'

export default {
  submitLLM(
    prompt: string,
    llm: string = 'gpt',
    history: Wm.PromptHistory[] = [],
    task_id: string = '-',
    encrypt: string = 'false'
  ): Promise<string> {
    if (!prompt) {
      return Promise.reject('输入不能为空')
    }
    const post_data = {
      source_text: prompt,
      history: history,
      llm: llm,
      task_id: task_id,
      encrypt: encrypt
    }
    return request
      .post('/text2video/text2llm', post_data)
      .then((res: any) => {
        // console.log(res);
        if (res && res.code === 0) {
          return res.data.result.answer
        } else {
          const errorMessage = res ? res.message : '未知错误'
          return Promise.reject(errorMessage)
        }
      })
      .catch((err: any) => {
        console.log(`err = ${JSON.stringify(err)}`)
        try {
          return Promise.reject(err.message)
        } catch (e) {
          return Promise.reject(`与LLM通讯失败`)
        }
      })
  },

  submitSD(
    task_id: string = '',
    img_idx: string = '',
    prompt: string = '',
    negative_prompt: string = '',
    width: string = '',
    height: string = '',
    sampler_index: string = '',
    seed: string = '',
    steps: string = '',
    cfg_scale: string = '',
    encrypt: string = 'false',
    model: string = ''
  ): Promise<{ domain_image_path: string; local_image_path: string }> {
    if (!prompt) {
      return Promise.reject('SD提示词不能为空')
    }
    const post_data = {
      task_id: task_id,
      img_idx: img_idx,
      prompt: prompt,
      negative_prompt: negative_prompt,
      sampler_index: sampler_index,
      seed: seed,
      steps: steps,
      width: width,
      height: height,
      cfg_scale: cfg_scale,
      encrypt: encrypt,
      model: model
    }
    return request
      .post('/text2video/text2img', post_data)
      .then((res: any) => {
        // console.log(res);
        if (res && res.code === 0) {
          return {
            domain_image_path: res.data.result.domain_image_path,
            local_image_path: res.data.result.local_image_path
          }
        } else {
          const errorMessage = res ? res.message : '未知错误'
          return Promise.reject(errorMessage)
        }
      })
      .catch((err: any) => {
        console.log(`err = ${JSON.stringify(err)}`)
        try {
          return Promise.reject(err.message)
        } catch (e) {
          return Promise.reject(`与 stable-diffusion-webui Api 通讯失败`)
        }
      })
  },

  submitGenVideo(gen_video_param: any): Promise<string> {
    if (!gen_video_param) {
      return Promise.reject('输入不能为空')
    }
    const post_data = gen_video_param
    return request
      .post('/text2video/gen_video', post_data)
      .then((res: any) => {
        // console.log(res);
        if (res && res.code === 0) {
          return res.data.result.domain_video_path
        } else {
          const errorMessage = res ? res.message : '未知错误'
          return Promise.reject(errorMessage)
        }
      })
      .catch((err: any) => {
        console.log(`err = ${JSON.stringify(err)}`)
        try {
          return Promise.reject(err.message)
        } catch (e) {
          return Promise.reject(`gen_video接口通讯失败`)
        }
      })
  },

  submitPwdCheck(pwd: string): Promise<string> {
    if (!pwd) {
      return Promise.reject('密码不能为空')
    }
    const post_data = { pwd: pwd }
    return request
      .post('/text2video/pwd_check', post_data)
      .then((res: any) => {
        // console.log(res);
        if (res && res.code === 0) {
          return res.data.result
        } else {
          const errorMessage = res ? res.message : '未知错误'
          return Promise.reject(errorMessage)
        }
      })
      .catch((err: any) => {
        console.log(`err = ${JSON.stringify(err)}`)
        try {
          return Promise.reject(err.message)
        } catch (e) {
          return Promise.reject(`与pwd_check接口通讯失败`)
        }
      })
  },

  submitTranslateToEn(
    input_string: string,
    task_id: string = '-',
    encrypt: string = 'false'
  ): Promise<string> {
    if (!input_string) {
      return Promise.reject('输入不能为空')
    }
    const post_data = { input_string: input_string, task_id: task_id, encrypt: encrypt }
    return request
      .post('/text2video/translate_to_en', post_data)
      .then((res: any) => {
        // console.log(res);
        if (res && res.code === 0) {
          return res.data.result
        } else {
          const errorMessage = res ? res.message : '未知错误'
          return Promise.reject(errorMessage)
        }
      })
      .catch((err: any) => {
        console.log(`err = ${JSON.stringify(err)}`)
        try {
          return Promise.reject(err.message)
        } catch (e) {
          return Promise.reject(`与翻译接口通讯失败`)
        }
      })
  },

  submitAddTextToImg(param: any): Promise<{ domain_image_path: string; local_image_path: string }> {
    const post_data = param
    return request
      .post('/text2video/add_text_to_img', post_data)
      .then((res: any) => {
        // console.log(res);
        if (res && res.code === 0) {
          return {
            domain_image_path: res.data.result.domain_image_path,
            local_image_path: res.data.result.local_image_path
          }
        } else {
          const errorMessage = res ? res.message : '未知错误'
          return Promise.reject(errorMessage)
        }
      })
      .catch((err: any) => {
        console.log(`err = ${JSON.stringify(err)}`)
        try {
          return Promise.reject(err.message)
        } catch (e) {
          return Promise.reject(`add_text_to_img接口通讯失败`)
        }
      })
  },

  submitTest(prompt: string): Promise<string> {
    const post_data = { source_text: prompt }
    return request
      .post('/text2video/test', post_data)
      .then((res: any) => {
        // console.log(res);
        if (res && res.code === 0) {
          return res.data.result
        } else {
          const errorMessage = res ? res.message : '未知错误'
          return Promise.reject(errorMessage)
        }
      })
      .catch((err: any) => {
        console.log(`err = ${JSON.stringify(err)}`)
        try {
          return Promise.reject(err.message)
        } catch (e) {
          return Promise.reject(`与Test Api通讯失败`)
        }
      })
  },

  submitImgToText(param: any): Promise<string> {
    const post_data = param
    return request
      .post('/text2video/img2text', post_data)
      .then((res: any) => {
        // console.log(res);
        if (res && res.code === 0) {
          return res.data.result
        } else {
          const errorMessage = res ? res.message : '未知错误'
          return Promise.reject(errorMessage)
        }
      })
      .catch((err: any) => {
        console.log(`err = ${JSON.stringify(err)}`)
        try {
          return Promise.reject(err.message)
        } catch (e) {
          return Promise.reject(`与Img2Text Api通讯失败`)
        }
      })
  },

  submitImgTextMatch(param: any): Promise<any[]> {
    const post_data = param
    return request
      .post('/text2video/img_text_match', post_data)
      .then((res: any) => {
        // console.log(res);
        if (res && res.code === 0) {
          return res.data.result
        } else {
          const errorMessage = res ? res.message : '未知错误'
          return Promise.reject(errorMessage)
        }
      })
      .catch((err: any) => {
        console.log(`err = ${JSON.stringify(err)}`)
        try {
          return Promise.reject(err.message)
        } catch (e) {
          return Promise.reject(`与ImgTextMatch Api通讯失败`)
        }
      })
  },

  submitCutOutImg(param: any): Promise<any> {
    const post_data = param
    return request
      .post('/text2video/cutout_from_img', post_data)
      .then((res: any) => {
        // console.log(res);
        if (res && res.code === 0) {
          return res.data.result
        } else {
          const errorMessage = res ? res.message : '未知错误'
          return Promise.reject(errorMessage)
        }
      })
      .catch((err: any) => {
        console.log(`err = ${JSON.stringify(err)}`)
        try {
          return Promise.reject(err.message)
        } catch (e) {
          return Promise.reject(`与 cutout_from_img Api 通讯失败`)
        }
      })
  },

  submitSDInPaint(
    task_id: string = '',
    img_idx: string = '',
    prompt: string = '',
    negative_prompt: string = '',
    width: string = '',
    height: string = '',
    sampler_index: string = '',
    seed: string = '',
    steps: string = '',
    cfg_scale: string = '',
    encrypt: string = 'false',
    model: string = '',
    base_img: string = '',
    mask: string = '',
    img_data_type: string = ''
  ): Promise<{ domain_image_path: string; local_image_path: string }> {
    if (!prompt || !base_img || !mask) {
      return Promise.reject('SD提示词、基础图、mask均不能为空')
    }
    const post_data = {
      task_id: task_id,
      img_idx: img_idx,
      prompt: prompt,
      negative_prompt: negative_prompt,
      sampler_index: sampler_index,
      seed: seed,
      steps: steps,
      width: width,
      height: height,
      cfg_scale: cfg_scale,
      encrypt: encrypt,
      model: model,
      base_img: base_img,
      mask: mask,
      img_data_type: img_data_type
    }
    return request
      .post('/text2video/img2img_inpaint', post_data)
      .then((res: any) => {
        // console.log(res);
        if (res && res.code === 0) {
          return {
            domain_image_path: res.data.result.domain_image_path,
            local_image_path: res.data.result.local_image_path
          }
        } else {
          const errorMessage = res ? res.message : '未知错误'
          return Promise.reject(errorMessage)
        }
      })
      .catch((err: any) => {
        console.log(`err = ${JSON.stringify(err)}`)
        try {
          return Promise.reject(err.message)
        } catch (e) {
          return Promise.reject(`与 img2img_inpaint Api 通讯失败`)
        }
      })
  },

  submitGenDigitHumanVideo(post_data: any): Promise<string> {
    if (!post_data) {
      return Promise.reject('输入不能为空')
    }
    return request
      .post('/text2video/gen_video_digithuman', post_data)
      .then((res: any) => {
        // console.log(res);
        if (res && res.code === 0) {
          if (res.data.result.final_video_oss) {
            return res.data.result.final_video_oss
          } else {
            return Promise.reject('视频合成失败')
          }
        } else {
          const errorMessage = res ? res.message : '未知错误'
          return Promise.reject(errorMessage)
        }
      })
      .catch((err: any) => {
        console.log(`err = ${JSON.stringify(err)}`)
        try {
          return Promise.reject(err.message)
        } catch (e) {
          return Promise.reject(`与后端 gen_video_digithuman 接口通讯失败`)
        }
      })
  }
}
