import { ref, reactive } from 'vue'
import type { CSSProperties } from 'vue'

interface MyMarkInterface {
  style: CSSProperties
  label: string
}
type MyMarkType = Record<number, MyMarkInterface | string>

export const useManyValues = () => {
  const screen = "竖屏";
  const horizontal_img_size = {width: "960", height: "540"};
  const vertical_img_size = {width: "540", height: "960"};
  const if_need_subtitle = "false";

  const sd_prompt_prefix = `(dressed:1.5),best quality,masterpiece,realistic,HDR,UHD,8K,best quality,highres,absurdres,realistic,masterpiece,
  Highly detailed,extreme detail description,Professional,cinematic_lighting,ultra-fine painting,full body,Vivid Colors,
  physically-based rendering,cinematic,`;

  const sd_negative_prompt_prefix = `multiple breasts, (mutated hands and fingers:1.5), (long body :1.3), 
  (mutation, poorly drawn :1.2) , black-white, bad anatomy, liquid body, liquid tongue, disfigured, 
  malformed, mutated, anatomical nonsense, malformed hands, long neck, blurred, 
  lowers, bad proportions, bad shadow, uncoordinated body, unnatural body, fused breasts, 
  bad breasts, huge breasts, poorly drawn breasts, extra breasts, liquid breasts, heavy breasts, missing breasts, 
  huge haunch, huge thighs, huge calf, bad hands, fused hand, missing hand, disappearing arms, disappearing thigh, 
  disappearing calf, disappearing legs, fused ears, bad ears, poorly drawn ears, extra ears, liquid ears, heavy ears, 
  missing ears, fused animal ears, bad animal ears, poorly drawn animal ears, extra animal ears, liquid animal ears, 
  heavy animal ears, missing animal ears, text, ui, error, missing fingers, missing limb, fused fingers, 
  one hand with more than 5 fingers, one hand with less than 5 fingers, one hand with more than 5 digit, 
  one hand with less than 5 digit, extra digit, fewer digits, fused digit, missing digit, bad digit, liquid digit, 
  colorful tongue, black tongue, cropped, watermark, username, blurry, JPEG artifacts, signature, 3D, 3D game, 
  3D game scene, 3D character, malformed feet, extra feet, bad feet, poorly drawn feet, fused feet, missing feet, 
  extra shoes, bad shoes, fused shoes, more than two shoes, poorly drawn shoes, bad gloves, poorly drawn gloves, 
  fused gloves, bad cum, poorly drawn cum, fused cum, bad hairs, poorly drawn hairs, fused hairs, big muscles, ugly, 
  bad face, fused face, poorly drawn face, cloned face, big face, long face, bad eyes, fused eyes poorly drawn eyes, 
  extra eyes, malformed limbs, more than 2 nipples, missing nipples, different nipples, fused nipples, bad nipples, 
  poorly drawn nipples, black nipples, colorful nipples, gross proportions. short arm, (((missing arms))), missing thighs, 
  missing calf, missing legs, mutation, duplicate, morbid, mutilated, poorly drawn hands, more than 1 left hand, 
  more than 1 right hand, deformed, (blurry), disfigured, missing legs, extra arms, extra thighs, more than 2 thighs, 
  extra calf, fused calf, nsfw,logo,text,extra legs, bad knee, extra knee, more than 2 legs, bad tails, bad mouth, 
  fused mouth, poorly drawn mouth, bad tongue, tongue within mouth, too long tongue, black tongue, big mouth, cracked mouth, 
  bad mouth, dirty face, dirty teeth, dirty pantie, fused pantie, poorly drawn pantie, fused cloth, poorly drawn cloth, bad pantie, 
  yellow teeth, thick lips, bad cameltoe, colorful cameltoe, bad asshole, poorly drawn asshole, fused asshole, missing asshole, 
  bad anus, bad pussy, bad crotch, bad crotch seam, fused anus, fused pussy, fused anus, fused crotch, poorly drawn crotch, 
  fused seam, poorly drawn anus, poorly drawn pussy, poorly drawn crotch, poorly drawn crotch seam, bad thigh gap, missing thigh gap, 
  fused thigh gap, liquid thigh gap, poorly drawn thigh gap, poorly drawn anus, bad collarbone, fused collarbone, missing collarbone, 
  liquid collarbone, obesity, worst quality, low quality, normal quality, liquid tentacles, bad tentacles, poorly drawn tentacles, 
  split tentacles, fused tentacles, missing clit, bad clit, fused clit, colorful clit, black clit, liquid clit, QR code, bar code, censored, 
  safety panties, safety knickers, beard, furry ,pony, pubic hair, mosaic, excrement, faeces, shit, futa, testis,mutated hands and fingers,
  deformed,bad anatomy,disfigured,poorly drawn face,lowres,mutated,extra limb,ugly,poorly drawn hands,missing limb,floating limbs,
  disconnected limbs,malformed hands,out of focus,long neck,long body,gape,`;

  const llms = {
    tyqw_online: {'api': 'tyqw', 'name':'线上通义千问'},
    baichuan: {'api': 'langchain', 'name':'本地baichuan2-7b'},
    qwen_local: {'api': 'langchain', 'name':'本地Qwen-7B-Chat'},
    chatgpt: {'api': 'gpt', 'name':'chatgpt'},
  };

  const horizontal_data = {
    task_id: "20240209114425596",
    chatgpt_prompt: `生成一个50字的小故事`,
    chatgpt_answer: ``,
    chatgpt_answer_roles: [],
    adapt_result_json: [],
    final_video: ``,
  };

  const vertical_data = {
    task_id: "20240220181602687",
    chatgpt_prompt: `生成一个50字的科幻小故事，阿凡达系列`,
    chatgpt_answer: `在宁静的森林里。一场奇特的食物大战正在上演。一只机灵的小松鼠。眼尖地发现了一块香气扑鼻的奶油蛋糕，正惬意地躺在熊猫阿宝的竹篮里。蛋糕上的水果点缀和醇厚的奶油似乎在向小松鼠招手，它的口水都快流成一条小溪了。`,
    chatgpt_answer_roles: [],
    adapt_result_json: [],
    final_video: ``,
  };

  const en_vertical_data = {
    task_id: "20240225222232784",
    chatgpt_prompt: `Generate a 50 words science fiction short story, Avatar series`,
    chatgpt_answer: `In a futuristic world, humans have developed the ability to upload their consciousness into virtual avatars. These avatars explore distant planets, collecting information for their creators. One day, a group of avatars stumble upon a planet inhabited by sentient beings who are also able to upload their consciousness. A new alliance is formed.`,
    chatgpt_answer_roles: [],
    adapt_result_json: [],
    final_video: ``,
  };

  const marks = reactive<MyMarkType>({
    '-100': '-100%',
    '-90': '-90%',
    '-80': '-80%',
    '-70': '-70%',
    '-60': '-60%',
    '-50': '-50%',
    '-40': '-40%',
    '-30': '-30%',
    '-20': '-20%',
    '-10': '-10%',
    0: {
      style: {
        color: '#1989FA',
      },
      label: '标准',
    },
    10: '+10%',
    20: '+20%',
    30: '+30%',
    40: '+40%',
    50: '+50%',
    60: '+60%',
    70: '+70%',
    80: '+80%',
    90: '+90%',
    100: '+100%',
  });

  const bgm_volume_marks = reactive<MyMarkType>({
    0: '-100%',
    0.5: '-50%',
    1.0: {
      style: {
        color: '#1989FA',
      },
      label: '标准音量',
    },
    1.5: '+50%',
    2.0: '+100%',
  });

  const voices = [
    {
      value: 'zh-CN-liaoning-XiaobeiNeural',
      gender: 'Female',
      label: '女，东北口音',
    },
    {
      value: 'zh-CN-shaanxi-XiaoniNeural',
      gender: 'Female',
      label: '女，陕西口音',
    },
    {
      value: 'zh-CN-XiaoxiaoNeural',
      gender: 'Female',
      label: '女，像个老师',
    },
    {
      value: 'zh-CN-XiaoyiNeural',
      gender: 'Female',
      label: '女，小女孩',
    },
    {
      value: 'zh-CN-YunjianNeural',
      gender: 'Male',
      label: '男，成熟稳重',
    },
    {
      value: 'zh-CN-YunxiaNeural',
      gender: 'Male',
      label: '男，小男孩',
    },
    {
      value: 'zh-CN-YunxiNeural',
      gender: 'Male',
      label: '男，大哥哥',
    },{
      value: 'zh-CN-YunyangNeural',
      gender: 'Male',
      label: '男，像个播音员',
    },{
      value: 'zh-HK-HiuGaaiNeural',
      gender: 'Female',
      label: '女，粤语，中年',
    },{
      value: 'zh-HK-HiuMaanNeural',
      gender: 'Female',
      label: '女，粤语，年轻',
    },{
      value: 'zh-HK-WanLungNeural',
      gender: 'Male',
      label: '男，粤语',
    },{
      value: 'zh-TW-HsiaoChenNeural',
      gender: 'Female',
      label: '女，台湾腔',
    },{
      value: 'zh-TW-HsiaoYuNeural',
      gender: 'Female',
      label: '女，台湾，偏普通话',
    },{
      value: 'zh-TW-YunJheNeural',
      gender: 'Male',
      label: '男，台湾腔',
    },
  ];

  const voices_en = [
    {
      value: 'en-US-BrianNeural',
      gender: 'Male',
      label: '男，美式磁性',
    },
  ];

  const bgm = [
    {
      value: '',
      label: '无',
    },
    {
      value: '安魂曲',
      label: '安魂曲',
    },
    {
      value: '解忧曲',
      label: '解忧曲',
    },
    {
      value: 'Anacreon',
      label: 'Anacreon',
    },
    {
      value: 'MySunset',
      label: 'MySunset',
    },
    {
      value: 'WindyHill',
      label: 'WindyHill',
    },
    {
      value: '雨声',
      label: '雨声',
    },
    {
      value: '大自然',
      label: '大自然',
    },
  ];

  const role_attribute_options = [
    {
      value: '人',
      label: '人',
    },
    {
      value: '动物',
      label: '动物',
    },
  ];

  const sd_paras = {
    dreamshaperXL_v21TurboDPMSDE: {
      sampler_index: "DPM++ SDE Karras",
      seed: "-1",
      steps: "6",
      cfg_scale: "2",
    },
    juggernautXL_v9Rdphoto2Lightning: {
      sampler_index: "Euler",
      seed: "-1",
      steps: "8",
      cfg_scale: "2",
    },
  };
  
  return {
    screen: screen,
    horizontal_img_size: horizontal_img_size,
    vertical_img_size: vertical_img_size,
    sd_prompt_prefix: sd_prompt_prefix,
    sd_negative_prompt_prefix: sd_negative_prompt_prefix,
    llms: llms,
    horizontal_data: horizontal_data,
    vertical_data: vertical_data,
    if_need_subtitle: if_need_subtitle,
    en_vertical_data: en_vertical_data,
    marks: marks,
    voices: voices,
    voices_en: voices_en,
    bgm: bgm,
    bgm_volume_marks: bgm_volume_marks,
    role_attribute_options: role_attribute_options,
    sd_paras: sd_paras,
  }
}
