import FileSaver from 'file-saver'
export default class fileSave {
  /**
   * 导出Excel文件
   * @param {*} res   文件流
   * @param {*} name  文件名
   */
  static getExcel(res: any, name: string) {
    const blob = new Blob([res], {
      type: 'application/vnd.ms-excel'
    })
    FileSaver.saveAs(blob, name + '.xlsx')
  }

  /**
   * 导出CSV文件
   * @param {*} res   文件流
   * @param {*} name  文件名
   */
  static getCsv(res: any, name: string) {
    const blob = new Blob([res], {
      type: 'application/vnd.ms-excel'
    })
    FileSaver.saveAs(blob, name + '.csv')
  }

  /**
   * 导出图片1
   * @param {*} url 图片地址
   * @param {*} name  文件名
   */
  static getImgURLs(url: string, name: string) {
    const last = url.substring(url.lastIndexOf('.'), url.length)
    FileSaver.saveAs(url, `${name}${last}`)
  }
  /**
   * 导出图片2
   * @param {*} res 文件流
   * @param {*} name  文件名
   */
  static downLoadImg(res: any, filename: string, type = 'image/jpeg') {
    const blob = new Blob([res], {
      type: type
    })
    FileSaver.saveAs(blob, `${filename}`)
  }
  /**
   * 导出图片3
   * @param {*} res 文件流
   * @param {*} name  文件名
   */
  static downLoadImgByUrl(url: any, filename: string, type = 'image/jpeg') {
    FileSaver.saveAs(url, `${filename}`)
  }

  /**
   * 下载文本文件
   */
  static getTxtFile(url: string, name: string) {
    FileSaver.saveAs(url, `${name}.txt`)
  }

  /**
   * 下载文件
   */
  static getVideoFile(url: string, name: string) {
    FileSaver.saveAs(url, `${name}`)
  }

  /**
   * 下载文件
   */
  static getFile(url: string, name: string) {
    FileSaver.saveAs(url, `${name}`)
  }
}
