import { ref, reactive } from 'vue'
import type { CSSProperties } from 'vue'

interface MyMarkInterface {
  style: CSSProperties
  label: string
}
type MyMarkType = Record<number, MyMarkInterface | string>

export const useManyValues = () => {
  const screen = "竖屏";
  const horizontal_img_size = {width: "960", height: "540"};
  const vertical_img_size = {width: "540", height: "960"};
  const if_need_subtitle = "false";

  const sd_prompt_prefix = `,best quality,masterpiece,realistic,HDR,UHD,8K,best quality,highres,absurdres,realistic,masterpiece,
  Highly detailed,extreme detail description,Professional,cinematic_lighting,ultra-fine painting,full body,Vivid Colors,
  physically-based rendering,cinematic`;

  const sd_negative_prompt_prefix = `multiple breasts, (mutated hands and fingers:1.5), (long body :1.3), 
  (mutation, poorly drawn :1.2) , black-white, bad anatomy, liquid body, liquid tongue, disfigured, 
  malformed, mutated, anatomical nonsense, malformed hands, long neck, blurred, 
  lowers, bad proportions, bad shadow, uncoordinated body, unnatural body, fused breasts, 
  bad breasts, huge breasts, poorly drawn breasts, extra breasts, liquid breasts, heavy breasts, missing breasts, 
  huge haunch, huge thighs, huge calf, bad hands, fused hand, missing hand, disappearing arms, disappearing thigh, 
  disappearing calf, disappearing legs, fused ears, bad ears, poorly drawn ears, extra ears, liquid ears, heavy ears, 
  missing ears, fused animal ears, bad animal ears, poorly drawn animal ears, extra animal ears, liquid animal ears, 
  heavy animal ears, missing animal ears, text, ui, error, missing fingers, missing limb, fused fingers, 
  one hand with more than 5 fingers, one hand with less than 5 fingers, one hand with more than 5 digit, 
  one hand with less than 5 digit, extra digit, fewer digits, fused digit, missing digit, bad digit, liquid digit, 
  colorful tongue, black tongue, cropped, watermark, username, blurry, JPEG artifacts, signature, 3D, 3D game, 
  3D game scene, 3D character, malformed feet, extra feet, bad feet, poorly drawn feet, fused feet, missing feet, 
  extra shoes, bad shoes, fused shoes, more than two shoes, poorly drawn shoes, bad gloves, poorly drawn gloves, 
  fused gloves, bad cum, poorly drawn cum, fused cum, bad hairs, poorly drawn hairs, fused hairs, big muscles, ugly, 
  bad face, fused face, poorly drawn face, cloned face, big face, long face, bad eyes, fused eyes poorly drawn eyes, 
  extra eyes, malformed limbs, more than 2 nipples, missing nipples, different nipples, fused nipples, bad nipples, 
  poorly drawn nipples, black nipples, colorful nipples, gross proportions. short arm, (((missing arms))), missing thighs, 
  missing calf, missing legs, mutation, duplicate, morbid, mutilated, poorly drawn hands, more than 1 left hand, 
  more than 1 right hand, deformed, (blurry), disfigured, missing legs, extra arms, extra thighs, more than 2 thighs, 
  extra calf, fused calf, nsfw,logo,text,extra legs, bad knee, extra knee, more than 2 legs, bad tails, bad mouth, 
  fused mouth, poorly drawn mouth, bad tongue, tongue within mouth, too long tongue, black tongue, big mouth, cracked mouth, 
  bad mouth, dirty face, dirty teeth, dirty pantie, fused pantie, poorly drawn pantie, fused cloth, poorly drawn cloth, bad pantie, 
  yellow teeth, thick lips, bad cameltoe, colorful cameltoe, bad asshole, poorly drawn asshole, fused asshole, missing asshole, 
  bad anus, bad pussy, bad crotch, bad crotch seam, fused anus, fused pussy, fused anus, fused crotch, poorly drawn crotch, 
  fused seam, poorly drawn anus, poorly drawn pussy, poorly drawn crotch, poorly drawn crotch seam, bad thigh gap, missing thigh gap, 
  fused thigh gap, liquid thigh gap, poorly drawn thigh gap, poorly drawn anus, bad collarbone, fused collarbone, missing collarbone, 
  liquid collarbone, obesity, worst quality, low quality, normal quality, liquid tentacles, bad tentacles, poorly drawn tentacles, 
  split tentacles, fused tentacles, missing clit, bad clit, fused clit, colorful clit, black clit, liquid clit, QR code, bar code, censored, 
  safety panties, safety knickers, beard, furry ,pony, pubic hair, mosaic, excrement, faeces, shit, futa, testis,mutated hands and fingers,
  deformed,bad anatomy,disfigured,poorly drawn face,lowres,mutated,extra limb,ugly,poorly drawn hands,missing limb,floating limbs,
  disconnected limbs,malformed hands,out of focus,long neck,long body,gape,`;

  const llms = {
    tyqw_online: {'api': 'tyqw', 'name':'线上通义千问'},
    baichuan: {'api': 'langchain', 'name':'本地baichuan2-7b'},
    qwen_local: {'api': 'langchain', 'name':'本地Qwen-7B-Chat'},
    chatgpt: {'api': 'gpt', 'name':'chatgpt'},
    kimi: {'api': 'kimi', 'name':'kimi'},
  };

  const horizontal_data = {
    task_id: "20240209114425596",
    chatgpt_prompt: `生成一个50字的小故事`,
    chatgpt_answer: ``,
    chatgpt_answer_roles: [],
    all_roles: "",
    adapt_result_json: [],
    final_video: ``,
  };

  const vertical_data = {
    task_id: "20240220181602687",
    chatgpt_prompt: `生成一个50字的科幻小故事，阿凡达系列`,
    chatgpt_answer: `森林里的美味秘密是什么呢？在葱郁的绿林中，一只机敏的小松鼠和一只温顺的大熊结伴而行，他们跨越山涧，攀爬树木，只为寻找传说中的金巧蒂。这不仅仅是一种美食，而是一段由新鲜、柔软、香酥编织的传奇。狡猾的狐狸也觊觎这份美味，但在小松鼠和大熊的智勇合作下，美味得以保全。他们分享了这份酥香，友谊也在森林中流传开来。`,
    chatgpt_answer_roles: [
      {
          "角色": "小松鼠",
          "角色关键词": "",
          "角色关键词英文": "",
          "属性": "动物"
      },
      {
          "角色": "大熊",
          "角色关键词": "",
          "角色关键词英文": "",
          "属性": "动物"
      },
      {
          "角色": "狐狸",
          "角色关键词": "",
          "角色关键词英文": "",
          "属性": "动物"
      }
  ],
    adapt_result_json: [
      {
          "编号": "1",
          "场景描述": "森林里的美味秘密是什么呢",
          "场景关键词": "在葱郁神秘的森林深处，隐藏着一种令人垂涎欲滴的美食秘密，引得动物们纷纷探寻，交织出一段段奇妙冒险。",
          "场景关键词英文": "Deep in the lush and mysterious forest, there is a mouth-watering food secret hidden, which attracts animals to explore and interweave a wonderful adventure.",
          "角色": "",
          "角色关键词": "",
          "角色关键词英文": "",
          "画面描述词": "Deep in the lush and mysterious forest, there is a mouth-watering food secret hidden, which attracts animals to explore and interweave a wonderful adventure.,",
          "本镜配图": "http://wm-tools-backend.frp.wmdigit.com:8888/assets/outputs/20240320160758713/img/1_resized.png?v=20240320160811071",
          "local_image_path": "assets/outputs/20240320160758713/img/1_resized.png",
          "info": "",
          "roles": []
      }
  ],
    all_roles: "小松鼠, 大熊, 狐狸",
    final_video: ``,
  };

  const en_vertical_data = {
    task_id: "20240225222232784",
    chatgpt_prompt: `Generate a 50 words science fiction short story, Avatar series`,
    chatgpt_answer: `In a futuristic world, humans have developed the ability to upload their consciousness into virtual avatars. These avatars explore distant planets, collecting information for their creators. One day, a group of avatars stumble upon a planet inhabited by sentient beings who are also able to upload their consciousness. A new alliance is formed.`,
    chatgpt_answer_roles: [],
    adapt_result_json: [],
    final_video: ``,
  };

  const marks = reactive<MyMarkType>({
    '-100': '-100%',
    '-90': '-90%',
    '-80': '-80%',
    '-70': '-70%',
    '-60': '-60%',
    '-50': '-50%',
    '-40': '-40%',
    '-30': '-30%',
    '-20': '-20%',
    '-10': '-10%',
    0: {
      style: {
        color: '#1989FA',
      },
      label: '标准',
    },
    10: '+10%',
    20: '+20%',
    30: '+30%',
    40: '+40%',
    50: '+50%',
    60: '+60%',
    70: '+70%',
    80: '+80%',
    90: '+90%',
    100: '+100%',
  });

  const bgm_volume_marks = reactive<MyMarkType>({
    0: '-100%',
    0.5: '-50%',
    1.0: {
      style: {
        color: '#1989FA',
      },
      label: '标准音量',
    },
    1.5: '+50%',
    2.0: '+100%',
  });

  const voices = [
    {
      value: 'zh-CN-liaoning-XiaobeiNeural',
      gender: 'Female',
      label: '女，东北口音',
    },
    {
      value: 'zh-CN-shaanxi-XiaoniNeural',
      gender: 'Female',
      label: '女，陕西口音',
    },
    {
      value: 'zh-CN-XiaoxiaoNeural',
      gender: 'Female',
      label: '女，像个老师',
    },
    {
      value: 'zh-CN-XiaoyiNeural',
      gender: 'Female',
      label: '女，小女孩',
    },
    {
      value: 'zh-CN-YunjianNeural',
      gender: 'Male',
      label: '男，成熟稳重',
    },
    {
      value: 'zh-CN-YunxiaNeural',
      gender: 'Male',
      label: '男，小男孩',
    },
    {
      value: 'zh-CN-YunxiNeural',
      gender: 'Male',
      label: '男，大哥哥',
    },{
      value: 'zh-CN-YunyangNeural',
      gender: 'Male',
      label: '男，像个播音员',
    },{
      value: 'zh-HK-HiuGaaiNeural',
      gender: 'Female',
      label: '女，粤语，中年',
    },{
      value: 'zh-HK-HiuMaanNeural',
      gender: 'Female',
      label: '女，粤语，年轻',
    },{
      value: 'zh-HK-WanLungNeural',
      gender: 'Male',
      label: '男，粤语',
    },{
      value: 'zh-TW-HsiaoChenNeural',
      gender: 'Female',
      label: '女，台湾腔',
    },{
      value: 'zh-TW-HsiaoYuNeural',
      gender: 'Female',
      label: '女，台湾，偏普通话',
    },{
      value: 'zh-TW-YunJheNeural',
      gender: 'Male',
      label: '男，台湾腔',
    },
  ];

  const voices_en = [
    {
      value: 'en-US-BrianNeural',
      gender: 'Male',
      label: '男，美式磁性',
    },
  ];

  const bgm = [
    {
      value: '',
      label: '无',
    },
    {
      value: '安魂曲',
      label: '安魂曲',
    },
    {
      value: '解忧曲',
      label: '解忧曲',
    },
    {
      value: 'Anacreon',
      label: 'Anacreon',
    },
    {
      value: 'MySunset',
      label: 'MySunset',
    },
    {
      value: 'WindyHill',
      label: 'WindyHill',
    },
    {
      value: '雨声',
      label: '雨声',
    },
    {
      value: '大自然',
      label: '大自然',
    },
  ];

  const role_attribute_options = [
    {
      value: '人',
      label: '人',
    },
    {
      value: '动物',
      label: '动物',
    },
  ];

  const sd_paras = {
    dreamshaperXL_v21TurboDPMSDE: {
      sampler_index: "DPM++ SDE Karras",
      seed: "-1",
      steps: "6",
      cfg_scale: "2",
      sd_prompt_prefix: sd_prompt_prefix
    },
    juggernautXL_v9Rdphoto2Lightning: {
      sampler_index: "Euler",
      seed: "-1",
      steps: "8",
      cfg_scale: "1.5",
      sd_prompt_prefix: sd_prompt_prefix + ", <lora:sdxl_lightning_8step_lora:0.2>",
    },
  };

  const marketing_template = {
    product_name: "金巧蒂原味猪肉松",
    product_description: 
    `1. 酥而不腻，入口即化
2. 原料主要采用新鲜猪后腿肉，经过水域立即处理，加上老师傅祖传的配方，结合现代化的生产工艺，锤炼出柔软酥松，绵而不腻，味香可口的“猪肉松”，并全程使用“多力牌”葵花油
3. 选用天然万家香酱油
4. 选用蒂纳海盐
5. 猪肉松的主要营养成分有碳水化合物、脂肪、蛋白质和多种矿物质，胆固醇含量低，且易于人体消化吸收，具有很高的营养价值。但是要注意一点，猪肉松不能与鹌鹑肉同食，吃多容易生黑斑哦
6. 我们“金巧蒂”的产品，确保是在屠宰后2小时内进行加工，绝对锁住肉质口感不流失。猪肉肉质细腻且营养价值丰富，对人体有极高的营养价值及保健作用，如长期食用可延年益寿，并有着汤汁浓郁，绕齿留香的特点`,
    target_people: "20-30岁年轻女生",
    text_role: "小松鼠",
    text_style: "幽默",
    story_type: "科幻",
    reference: "猪八戒娶媳妇儿的情节",
    words_num: 100,
    result1: "",
    result2: "",
    product_pic: "http://wm-tools-backend.frp.wmdigit.com:8888/assets/2024/03/12/887a52c6-e022-11ee-a7de-9be5c7a16c02_resized.png",
    product_pic_local: "assets/2024/03/12/887a52c6-e022-11ee-a7de-9be5c7a16c02_resized.png",
    product_pic_with_text: "http://wm-tools-backend.frp.wmdigit.com:8888/assets/2024/03/12/887a52c6-e022-11ee-a7de-9be5c7a16c02_resized_with_text.png",
    product_pic_with_text_local: "assets/2024/03/12/887a52c6-e022-11ee-a7de-9be5c7a16c02_resized_with_text.png",
    product_pic_titles: [
      {
        text: "金巧蒂原味猪肉松",
        color: "#FB7D01",
        bg_color: "",
        font_size: 60,
        position: 0.92,
      },
      {
        text: "促销价只要8.8！快来抢购吧~",
        color: "#FF008C",
        bg_color: "",
        font_size: 50,
        position: 0.41,
      },
      {
        text: "关注  点赞  评论\n记得一键三连哦",
        color: "#000000",
        bg_color: "",
        font_size: 50,
        position: 0.12,
      },
    ],
    product_pic_speech: "",
    cover_pic: "http://wm-tools-backend.frp.wmdigit.com:8888/assets/2024/03/12/10170c9e-e035-11ee-a7de-9be5c7a16c02_resized.jpg",
    cover_pic_local: "assets/2024/03/12/10170c9e-e035-11ee-a7de-9be5c7a16c02_resized.jpg",
    cover_pic_with_text: "http://wm-tools-backend.frp.wmdigit.com:8888/assets/2024/03/12/10170c9e-e035-11ee-a7de-9be5c7a16c02_resized_with_text.jpg",
    cover_pic_with_text_local: "assets/2024/03/12/10170c9e-e035-11ee-a7de-9be5c7a16c02_resized_with_text.jpg",
    cover_pic_titles: [
      {
        text: "猪猪的奇妙冒险",
        color: "#000000",
        bg_color: "#FFFFFF",
        font_size: 60,
        position: 0.37,
      },
    ],
  };
  
  return {
    screen: screen,
    horizontal_img_size: horizontal_img_size,
    vertical_img_size: vertical_img_size,
    sd_prompt_prefix: sd_prompt_prefix,
    sd_negative_prompt_prefix: sd_negative_prompt_prefix,
    llms: llms,
    horizontal_data: horizontal_data,
    vertical_data: vertical_data,
    if_need_subtitle: if_need_subtitle,
    en_vertical_data: en_vertical_data,
    marks: marks,
    voices: voices,
    voices_en: voices_en,
    bgm: bgm,
    bgm_volume_marks: bgm_volume_marks,
    role_attribute_options: role_attribute_options,
    sd_paras: sd_paras,
    marketing_template: marketing_template,
  }
}
