import aitoolsService from '@/api/service/aitoolsService';
import { trackUserAction } from './common';
import { ElMessage, ElMessageBox } from 'element-plus';
import utils from '@/utils/utils';
import { reactive, ref } from 'vue';

// 客户留资
export const myCustomerInfo = (form: any, title: any) => {
    const customer = reactive({
        name: '',
        mobile: '',
        company: '',
        note: '',
    })
    const customerInfoVisible = ref(false)
    const onCustomerInfoSubmit = async () => {
        if (!customer.name || !customer.mobile) {
            ElMessage({
                message: '请填写姓名和手机号',
                type: 'warning'
            })
            return
        }
        if (!utils.isPhone(customer.mobile)) {
            ElMessage({
                message: '手机号格式不正确',
                type: 'warning'
            })
            return
        }
        try {
            console.log(customer)
            let param: any = {
                name: customer.name,
                mobile: customer.mobile,
                company: customer.company,
                source: form.source,
                note: customer.note,
            }
            await aitoolsService.commonApi('记录客户信息', 'take_customer_info', param);
            // 统计
            trackUserAction(form.source, form.user_id, title.value, '客户留资')
            customerInfoVisible.value = false
            // 防止重复提交
            localStorage.setItem("isSubmitCustomerInfo", 'yes');
            // 新开一个浏览器窗口，打开一个链接
            openNewWindow();
        } catch (error) {
            ElMessage({
                message: String(error),
                type: 'error'
            })
        }
    }

    const openNewWindow = () => {
        if (form.source === 'pc') {
            window.open(form.report_url, '_blank');
        } else {
            if (form.source === 'wechat') {
                ElMessageBox.confirm(
                    '请先<span style="color: red;">「点击确认」</span>查看完整报告，如需保存报告到手机，再至右上角选择<span style="color: red;">「默认浏览器」</span>打开',
                    '微信提示',
                    {
                    confirmButtonText: '确认',
                    type: 'info',
                    center: true,
                    showClose: false,
                    showCancelButton: false,
                    dangerouslyUseHTMLString: true,
                    closeOnClickModal: false,
                    closeOnPressEscape: false,
                    }
                ).then(() => {
                    window.location.href = form.report_url;
                })
            } else {
                window.location.href = form.report_url;
            }
        }
    }
    const onClickDownloadPDF = () => {
        const isSubmitCustomerInfo = localStorage.getItem("isSubmitCustomerInfo");
        console.log('isSubmitCustomerInfo =', isSubmitCustomerInfo);
        if (isSubmitCustomerInfo === 'yes') {
            customerInfoVisible.value = false
            // 直接打开链接
            openNewWindow();
        } else {
            customerInfoVisible.value = true
        }
    }

    return {
        customer,
        customerInfoVisible,
        onCustomerInfoSubmit,
        onClickDownloadPDF,
    }

}
