import aitoolsService from '@/api/service/aitoolsService'

// 检测设备类型
export const detectDeviceType = () => {
  const userAgent = navigator.userAgent.toLowerCase()
  let source = ''
  if (userAgent.match(/mobile/i) || userAgent.match(/android/i) || userAgent.match(/iphone/i) || userAgent.match(/ipad/i)) {
    source = 'mobile'
    // if (userAgent.match(/iphone/i) || userAgent.match(/ipad/i)) {
    //   source = 'ios'
    // } else if (userAgent.match(/android/i)) {
    //   source = 'android'
    // }
    if (userAgent.match(/micromessenger/i)) {
        source = 'wechat'
    }
  } else {
    source = 'pc'
  }
  console.log('设备类型:', source)
  return source
}

// 记录用户操作
export const trackUserAction = async (source: string, user_id: string, content: string, action: string) => {
  let param: any = {
    source: source,
    user_id: user_id,
    content: content,
    action: action,
  }

  aitoolsService.commonApi('提交用户轨迹数据', 'track', param)
  .then((response) => {
    if (response == 'ok') {
      console.log(action, '上报成功')
    } else {
      console.log(action, '上报失败')
    }
  })
  .catch((error) => {
    console.log(action, '上报失败:', error)
  })
}

