import aitoolsService from '@/api/service/aitoolsService'
import utils from '@/utils/utils'
import {
  ElMessage,
  ElLoading,
  ElMessageBox
} from 'element-plus'
import type { Action } from 'element-plus'


export const onProcessing = (form: any, steps_active: any, process_loading: any, result_loading: any) => {
    const fileToClassify = async () => {
        if (!form.file_path || form.file_path.length == 0) {
            ElMessage({
                message: '请先上传文件',
                type: 'warning'
            })
            return
        }
        // 进入第二页
        from_first_to_second();
        
        // 清除结果
        form.sample_result = {
            root_path: '',
            data: [{
                dir_name: '',
                images: [],
            }]
        };

        // 提交处理请求
        try {
            let param: any = {
                task_id: form.task_id,
                file_path: form.file_path,
                crop_range: JSON.stringify(form.crop_range),
                box_range: JSON.stringify(form.box_range),
                output_type: "dir",
                classes_select: "",
                target_fps: form.target_fps, // 目标帧率
            }

            process_loading.value = true;
            
            // 发起请求
            aitoolsService.commonApi('提交处理', 'gen_sample_from_video', param)
            .then((response) => {
                // console.log(form)
                console.log(`接口返回：${response}`);
                form.sample_result = response;
                // 设置默认值
                form.classes_select = {}
                form.classes_select2 = {}
                response.data.forEach((item: { dir_name: string; images: string[] }) => {
                    form.classes_select[item.dir_name] = '0';
                    form.classes_select2[item.dir_name] = '';
                });
                process_loading.value = false;
            })
            .catch((error) => {
                ElMessage({
                    message: error,
                    type: 'error'
                });
                // // 重置task_id
                // form.task_id = utils.genDateTimeStr();
                // console.log('重置 task_id =', form.task_id);
                process_loading.value = false;
            })
        } catch (error: any) {
            ElMessage({
                message: error,
                type: 'error'
            });
            process_loading.value = false;
        }
    }

    function isAllDataClassified(): boolean {
        let is_ok = false;
        if (!form.sample_result?.data || !form.classes_select) {
            ElMessage({
                message: '数据未正确初始化',
                type: 'error'
            });
        }
        form.sample_result.data.every((item: { dir_name: string; images: string[] }) => {
            if (!form.classes_select.hasOwnProperty(item.dir_name)) {
                ElMessage({
                    message: `请为${item.dir_name}分类`,
                    type: 'error'
                });
            } else {
                is_ok = true
            }
        });
        return is_ok;
    }


    const classifyToDownload = async () => {
        if (!isAllDataClassified()) {
            return
        }
        // 进入第3页
        from_second_to_third();
        
        // 清除结果
        form.sample_path = '';

        // 提交处理请求
        try {
            let param: any = {
                task_id: form.task_id,
                file_path: form.file_path,
                crop_range: JSON.stringify(form.crop_range),
                box_range: JSON.stringify(form.box_range),
                output_type: "zip",
                classes_select: JSON.stringify(form.classes_select),
                target_fps: form.target_fps, // 目标帧率
            }

            result_loading.value = true;
            
            // 发起请求
            aitoolsService.commonApi('提交处理', 'gen_sample_from_video', param)
            .then((response) => {
                // console.log(form)
                console.log(`接口返回：${response}`);
                form.sample_path = response.sample_path;
                result_loading.value = false;
            })
            .catch((error) => {
                ElMessage({
                    message: error,
                    type: 'error'
                });
                // // 重置task_id
                // form.task_id = utils.genDateTimeStr();
                // console.log('重置 task_id =', form.task_id);
                result_loading.value = false;
            })
        } catch (error: any) {
            ElMessage({
                message: error,
                type: 'error'
            });
            result_loading.value = false;
        }
    }




    const from_first_to_second = () => {
        steps_active.value = 1
    }
    
    const back_to_first = () => {
        steps_active.value = 0;
        form.task_id = utils.genDateTimeStr();
        console.log('返回首页，task_id =', form.task_id);
    }

    const from_second_to_third = () => {
        steps_active.value = 2;
    }

    const back_to_second = () => {
        steps_active.value = 1;
        form.classes_select2 = JSON.parse(JSON.stringify(form.classes_select));
    }

    function downloadFile(url: string, filename?: string) {
        const a = document.createElement('a')
        a.href = url
        if (filename) {
            a.download = filename // 指定下载文件名
        }
        a.target = '_blank'
        document.body.appendChild(a)
        a.click()
        document.body.removeChild(a)
    }

    function deleteOneSample(sample_dir: string) {
        ElMessageBox.alert(`确认删除 ${sample_dir} 这行样本吗？`, '删除样本', {
            // autofocus: false,
            confirmButtonText: '删除',
            callback: (action: Action) => {
                if (action === 'confirm') {
                    // 删除 form.sample_result.data
                    const index = form.sample_result.data.findIndex((item: any) => item.dir_name === sample_dir);
                    form.sample_result.data.splice(index, 1);
                    // 删除 form.classes_select[sample_dir]
                    delete form.classes_select[sample_dir];
                    // 删除 form.classes_select2[sample_dir]
                    delete form.classes_select2[sample_dir];
                    
                    ElMessage({
                        type: 'success',
                        message: '删除成功'
                    })
                }
            },
        })
    }



    return {
        from_first_to_second,
        back_to_first,
        from_second_to_third,
        back_to_second,
        fileToClassify,
        classifyToDownload,
        downloadFile,
        process_loading,
        result_loading,
        deleteOneSample,
    }
}