import { ref } from 'vue'
import {
  ElMessage,
} from 'element-plus'

export function useCropBox(form: any, canvas: any, ctx: any) {
  const isDrawing = ref(false)
  const startX = ref(0)
  const startY = ref(0)
  const endX = ref(0)
  const endY = ref(0)
  const boxes = ref<Array<{ start: number[], end: number[] }>>([])

  function generate_canvas() {
    const el = document.getElementById('crop-canvas') as HTMLCanvasElement
    if (el) {
      canvas.value = el
      ctx.value = canvas.value.getContext('2d')
      // 设置 canvas 尺寸与视频一致
      const video = document.getElementById('video-player') as HTMLVideoElement
      if (video) {
        if (video.videoWidth > 0 && video.videoHeight > 0) {
          console.log('video size =', video.videoWidth, video.videoHeight)
          canvas.value.width = video.videoWidth
          canvas.value.height = video.videoHeight
          canvas.value.style.zIndex = '2'
          drawBoxes()
        }
      }
    }
  }

  function startDrawing(e: MouseEvent) {
    if (boxes.value.length >= 2) {
      while (boxes.value.length > 2) {
        boxes.value.pop()
      }
      return
    }
    const rect = canvas.value!.getBoundingClientRect()
    isDrawing.value = true
    startX.value = e.clientX - rect.left
    startY.value = e.clientY - rect.top
    endX.value = startX.value
    endY.value = startY.value
    console.log('开始绘制，起点:', startX.value, startY.value)
  }

  function draw(e: MouseEvent) {
    if (!isDrawing.value) return
    const rect = canvas.value!.getBoundingClientRect()
    endX.value = e.clientX - rect.left
    endY.value = e.clientY - rect.top
    clearCanvas()
    drawBoxes()
    drawRect(startX.value, startY.value, endX.value - startX.value, endY.value - startY.value)
  }

  function endDrawing() {
    if (!isDrawing.value) return
    isDrawing.value = false
    boxes.value.push({
      start: [startX.value, startY.value],
      end: [endX.value, endY.value]
    })
    clearCanvas()
    drawBoxes()
    console.log('结束绘制，终点:', endX.value, endY.value)
    console.log('框', boxes.value.length, '个: ', boxes.value)
    if (boxes.value.length === 1) {
      form.crop_range = boxes.value[0]
    }
    if (boxes.value.length === 2) {
      if (boxes.value[1].start[0] < boxes.value[0].start[0] 
        || boxes.value[1].start[1] < boxes.value[0].start[1]
        || boxes.value[1].end[0] > boxes.value[0].end[0]
        || boxes.value[1].end[1] > boxes.value[0].end[1]) {
        ElMessage({
            message: '扫描框必须在裁剪框内',
            type: 'warning'
        })
        reset()
      } else {
        form.box_range = boxes.value[1]
        form.is_set = true
      }
    }
  }

  function drawRect(x: number, y: number, width: number, height: number) {
    const c = ctx.value!
    c.strokeStyle = 'green'
    c.lineWidth = 2
    c.strokeRect(x, y, width, height)
  }

  function drawBoxes() {
    boxes.value.forEach(box => {
      drawRect(box.start[0], box.start[1], box.end[0] - box.start[0], box.end[1] - box.start[1])
    })
  }

  function clearCanvas() {
    const c = canvas.value!
    ctx.value!.clearRect(0, 0, c.width, c.height)
  }

  function reset() {
    if (boxes.value.length === 0) {
      return
    }
    while (boxes.value.length > 0) {
      boxes.value.pop()
    }
    clearCanvas()
    form.crop_range = {}
    form.box_range = {}
    form.is_set = false
    console.log('重置绘制数据')
  }

  return {
    startDrawing,
    draw,
    endDrawing,
    clearCanvas,
    reset,
    generate_canvas
  }
}