import aitoolsService from '@/api/service/aitoolsService'
import utils from '@/utils/utils'
import {
  ElMessage,
  ElLoading,
} from 'element-plus'
import { trackUserAction } from './common'
import { ref } from 'vue'

const delay = (ms: any) => new Promise((res) => setTimeout(res, ms))

export const opDataAnalysis = (form: any, title: any, steps_active: any, progress_percentage: any) => {
    // 开始分析
    const step_read_file_result = ref('');
    const step_data_clean_result = ref('');
    const step_analysis_result = ref('');
    const step_data_clean_result_store = ref('');
    const step_data_clean_result_dates = ref('');
    const onAnalysis = async () => {
        if (!form.excel_path || form.excel_path.length == 0) {
        ElMessage({
            message: '请先上传Excel',
            type: 'warning'
        })
        return
        }
        // 进入报告页
        from_analysis_to_report();
        
        // 清除变量
        form.process_info = '';
        form.report = '';
        form.report_url = '';
        form.process_status = '';

        // 提交数据分析请求
        try {
        // 统计提交次数
        trackUserAction(form.source, form.user_id, title.value, '提交数据分析')

        let param: any = {
            task_id: form.task_id,
            excel_path: form.excel_path,
            suggestion: form.suggestion,
        }
        // 发起第一个请求
        aitoolsService.commonApi('提交数据分析', 'op_data_analysis', param)
        .then((response) => {
            // console.log(form)
            console.log(`数据分析接口返回：${response}`)
        })
        .catch((error) => {
            // ElMessage({
            //     message: error,
            //     type: 'error'
            // });
            // 重置task_id
            form.task_id = utils.genDateTimeStr();
            console.log('重置 task_id =', form.task_id);
        })

        // 立即开始轮询
        const query_task_id = form.task_id;
        form.process_info = '【开始运行】\n';
        let error_cnt = 0;
        let all_cnt = 0;
        while (true) {
            try {
            console.log('获取数据分析处理进度');
            // 每隔1秒获取一次进度
            await delay(1000);
            // 发送请求获取分析进度
            const query_result = await aitoolsService.commonApi('查询数据分析进度', 'get_analysis_process_info', {task_id: query_task_id});
            form.process_status = query_result.status;
            console.log('数据分析', form.process_status);
            
            let process_info_obj = query_result.process_info;
            if ('read_file_result' in process_info_obj && 'read_file_count' in process_info_obj && step_read_file_result.value == '') {
                form.process_info += process_info_obj.read_file_result + '\n(还剩下 2 个步骤)\n\n<span style="font-color: #999; font-size: 16px;">正在运行数据清洗程序...</span>\n\n';
                step_read_file_result.value = process_info_obj.read_file_count;
            }
            if ('data_clean_result' in process_info_obj && step_data_clean_result.value == '') {
                form.process_info += process_info_obj.data_clean_result + '\n(还剩下 1 个步骤)\n\n<span style="font-color: #999; font-size: 16px;">DeepSeek正在分析数据并书写建议...</span>\n\n';
                step_data_clean_result.value = 'ok';
                if ('store_to_process' in process_info_obj) {
                    step_data_clean_result_store.value = process_info_obj.store_to_process;
                }
                if ('dates' in process_info_obj) {
                    step_data_clean_result_dates.value = process_info_obj.dates;
                }
            }
            if ('analysis_result' in process_info_obj && step_analysis_result.value == '') {
                form.process_info += process_info_obj.analysis_result + '\n最后一步\n\n<span style="font-color: #999; font-size: 16px;">正在为您生成专属数据报告...</span>\n\n';
                step_analysis_result.value = 'ok';
            }
            // console.log(form.process_info);
            if (form.process_status == 'done') {
                // await delay(2000);
                form.report = query_result.report;
                form.report_url = query_result.report_url;
                form.process_info += '请收好您的专属数据报告链接~\n'
                // form.process_info += '<a href="' + form.report_url + '" target="_blank">点击查看</a>\n\n';
                // form.process_info += '【运行结束】';
                console.log(form)
                break;
            }
            if (form.process_status == 'error') {
                form.process_info += process_info_obj.error_result + '请检查Excel重新提交分析。\n';
                form.process_info += '【运行结束】';
                break;
            }
            } catch (error: any) {
                console.log(error, error_cnt);
                error_cnt += 1;
                if (error_cnt > 10) {
                    break;
                }
                continue;
            }
            all_cnt += 1;
            if (all_cnt > 600) {
                break;
            }
        }
        } catch (error: any) {
            ElMessage({
                message: error,
                type: 'error'
            });
        } finally {
            // 重置task_id
            form.task_id = utils.genDateTimeStr();
            console.log('重置 task_id =', form.task_id);
            console.log('isSubmitCustomerInfo =', localStorage.getItem("isSubmitCustomerInfo"));
        }
    }

    const from_file_to_analysis = () => {
        steps_active.value = 1
        progress_percentage.value = 50
    }
    
    const back_to_file = () => {
        steps_active.value = 0
        progress_percentage.value = 0
    }

    const from_analysis_to_report = () => {
        steps_active.value = 2
        progress_percentage.value = 100
    }

    const back_to_analysis = () => {
        steps_active.value = 1
        progress_percentage.value = 50
    }

    return {
        from_file_to_analysis,
        back_to_file,
        onAnalysis,
        back_to_analysis,
        step_read_file_result,
        step_data_clean_result,
        step_analysis_result,
        step_data_clean_result_store,
        step_data_clean_result_dates,
    }
}