/**
 * 相关接口
 */
import request from '@/api/request'

export default {
  // 通用接口
  commonApi(api_name: string, api: string, post_data: any): Promise<any> {
    if (!api_name || !api || !post_data) {
      return Promise.reject('所有参数不能为空')
    }
    // console.log(post_data);
    return request
      .post(`/api/v1/chat_bot/chat/${api}`, post_data)
      .then((res: any) => {
        // console.log(res);
        if (res && res.code === 0) {
          if (res.data.result) {
            return res.data.result
          } else {
            return Promise.reject(`${api_name}接口未返回结果`)
          }
        } else {
          const errorMessage = res ? res.message : `${api_name}接口返回错误`
          return Promise.reject(errorMessage)
        }
      })
      .catch((err: any) => {
        console.log(`err = ${JSON.stringify(err)}`)
        try {
          return Promise.reject(err)
        } catch (e) {
          return Promise.reject(`与后端${api_name}接口通讯失败`)
        }
      })
  },
}
