//
//  TransportPurductCell.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/6.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "TransportPurductCell.h"
#define LeftMargin 13
#define TableHeight 44
#define SmallSize 10
#define SmallWidth 20
#define SpaceMargin 1
#define LeftWidth 40

#define ShowWidth 150
#define ShowHeight 20

@implementation TransportPurductCell
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{
    CGFloat headWidth = (ScreenSize.width - LeftWidth*2 - SpaceMargin* (4 -1))/4;
    
    
    self.seqLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, 0, SmallWidth, TableHeight))];
    self.seqLabel.textColor = GXF_CONTENT_COLOR;
    self.seqLabel.text = @"13";
    self.seqLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.titleLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftWidth, 0, headWidth, TableHeight))];
    self.titleLabel.textAlignment = NSTextAlignmentLeft;
    self.titleLabel.textColor = GXF_CONTENT_COLOR;
    self.titleLabel.text = @"苹果桃子";
    self.titleLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.standLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.titleLabel.frame) + SpaceMargin, 0, headWidth, TableHeight))];
    self.standLabel.textAlignment = NSTextAlignmentLeft;
    self.standLabel.textColor = GXF_CONTENT_COLOR;
    self.standLabel.text = @"80";
    self.standLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.countLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.standLabel.frame) + SpaceMargin, 0, headWidth, TableHeight))];
    self.countLabel.textAlignment = NSTextAlignmentLeft;
    self.countLabel.text = @"200";
    self.countLabel.textColor = GXF_CONTENT_COLOR;
    self.countLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.baseCountLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.countLabel.frame) + SpaceMargin, 0, headWidth, TableHeight))];
    self.baseCountLabel.textAlignment = NSTextAlignmentLeft;
    self.baseCountLabel.text = @"200";
    self.baseCountLabel.textColor = GXF_CONTENT_COLOR;
    self.baseCountLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.editBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.editBtn setImage:[UIImage imageNamed:@"selected"] forState:UIControlStateNormal];
    self.editBtn.frame = CGRectMake(ScreenSize.width - LeftWidth, 0, LeftWidth , TableHeight);
    self.editBtn.contentMode = UIViewContentModeScaleAspectFit;
    
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin,TableHeight-1, ScreenSize.width  - LeftMargin * 2, 1))];;
    self.lineLabel.backgroundColor = GXF_LINE_COLOR;
    
    [self.contentView addSubview:self.smallImageView];
    [self.contentView addSubview:self.seqLabel];
    [self.contentView addSubview:self.titleLabel];
    [self.contentView addSubview:self.standLabel];
    [self.contentView addSubview:self.countLabel];
    [self.contentView addSubview:self.baseCountLabel];

    [self.contentView addSubview:self.editBtn];
}
- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
