//
//  BottomTransportView.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/6.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "BottomTransportView.h"

#define ContentHeight 44
#define BtnWidth 100
#define BeginTag 8000
#define SpaceWidth (ScreenSize.width - 100*2)/3

@interface BottomTransportView ()<UIScrollViewDelegate>
{
    UIScrollView *_bottomSV;
    UIImageView *_moveImageView;
    UIButton *_currentBtn;
    UIButton *_addBtn;
}
@end

@implementation BottomTransportView

- (instancetype)initWithFrame:(CGRect)frame{
    self = [super initWithFrame:frame];
    if (self) {
        //界面
        [self bulidLayout];
    }
    return self;
}
#pragma mark - 布局
- (void)bulidLayout
{
    [self addChildView];
    
    [self createBottomView];
}
- (void)createBottomView{
    NSArray *arr = @[@"商品明细",@"费用明细"];
    
    _bottomSV = [[UIScrollView alloc]initWithFrame:CGRectMake(0,ContentHeight + 4, ScreenSize.width, CGRectGetHeight(self.frame) - ContentHeight-2)];
    _bottomSV.showsHorizontalScrollIndicator  = NO;
    _bottomSV.showsVerticalScrollIndicator = NO;
    _bottomSV.pagingEnabled = YES;
    _bottomSV.delegate = self;
    _bottomSV.backgroundColor = [UIColor yellowColor];
    _bottomSV.contentSize = CGSizeMake(ScreenSize.width * arr.count, CGRectGetHeight(_bottomSV.frame));
    [self addSubview:_bottomSV];
    
    for (NSInteger i = 0; i < arr.count; i++) {
        UIButton *btn = [UIButton buttonWithType:UIButtonTypeSystem];
        [btn setTitle:arr[i] forState:UIControlStateNormal];
        btn.frame = CGRectMake(SpaceWidth + (BtnWidth+SpaceWidth) * i, 0, BtnWidth, ContentHeight);
        [btn setTitleColor:GXF_CONTENT_COLOR forState:UIControlStateNormal];
        [btn setTitleColor:GXF_SAVE_COLOR forState:UIControlStateDisabled];
        btn.titleLabel.font = GXF_SIXTEENTEH_SIZE;
        btn.tag = i + BeginTag;
        [btn addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:btn];
        
        UIView *view = [[UIView alloc]initWithFrame:CGRectMake(CGRectGetWidth(_bottomSV.frame) * i, 0, CGRectGetWidth(_bottomSV.frame), CGRectGetHeight(_bottomSV.frame))];
        
        if (i == 0) {
            view.backgroundColor = [UIColor redColor];
            self.productVC.viewFrame = view.bounds;
            [view addSubview:self.productVC.view];
        }else if(i == 1){
            self.costVC.viewFrame = view.bounds;
            [view addSubview:self.costVC.view];
            view.backgroundColor = [UIColor blueColor];
        }
        [_bottomSV addSubview:view];
    }
    _moveImageView = [[UIImageView alloc]initWithFrame:CGRectMake(SpaceWidth, ContentHeight, BtnWidth,4)];
    _moveImageView.image  = [UIImage imageNamed:@"tab_line"];
    
     UILabel  *lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(0, ContentHeight +1, ScreenSize.width, 1))];
    lineLabel.backgroundColor = GXF_LINE_COLOR;
    lineLabel.font = GXF_FIFTEENTEN_SIZE;
    [self addSubview:lineLabel];
    [self addSubview:_moveImageView];
}

- (void)addChildView{
    self.productVC = [[ProductBillViewController alloc]init];
    self.productVC.twoTitle = @"+选择采购单";
    self.costVC = [[CostViewController alloc]init];
}
- (void)btnClick:(UIButton *)btn{
    NSInteger index = btn.tag - BeginTag;
    _currentBtn.enabled = YES;
    btn.enabled = NO;
    _currentBtn = btn;
    [UIView animateWithDuration:0.5 animations:^{
        CGRect moveFrame = _moveImageView.frame;
        moveFrame.origin.x = SpaceWidth + (BtnWidth+SpaceWidth) * index;
        _moveImageView.frame = moveFrame;
        _bottomSV.contentOffset=CGPointMake(index * self.frame.size.width, 0);
    }];
}

- (void)scrollViewDidEndDecelerating:(UIScrollView *)scrollView{
    CGFloat offsetX = scrollView.contentOffset.x / self.frame.size.width;
    [UIView animateWithDuration:0.5 animations:^{
        CGRect moveFrame = _moveImageView.frame;
        moveFrame.origin.x = SpaceWidth + (BtnWidth+SpaceWidth) * offsetX;
        _moveImageView.frame = moveFrame;
    }];
    _currentBtn.enabled = YES;
    UIButton *btn = (UIButton *) [self viewWithTag:offsetX + BeginTag];
    btn.enabled = NO;
    _currentBtn = btn;
}

- (void)refreshProduct:(NSArray *)productArr{
    if (self.productVC.productArr) {
        [self.productVC.productArr addObjectsFromArray:productArr];
        [self.productVC.tableView reloadData];
    }
}
- (void)refreshCost:(NSArray *)costArr{
    
}

@end
