//
//  TransportPurchaseViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/6.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "TransportPurchaseViewController.h"
#import "TransportPurchaseCell.h"
#import "QueryOrder.h"
#define TopMargin 50
#define TableHeight 50
@interface TransportPurchaseViewController ()<UITextFieldDelegate,UITableViewDataSource,UITableViewDelegate>
@property (nonatomic,strong)NSMutableArray *indexArr;
@property (nonatomic,strong)NSMutableArray *dataArr;
@property (nonatomic,strong)UITableView *tableView;
@property (nonatomic,strong)UITextField *selectTextFiled;
@end

@implementation TransportPurchaseViewController

- (instancetype)init{
    self = [super init];
    if (self) {
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(getSelectPurchaseProduct:) name:KNOTIFICATION_getSelectPurchaseProduct object:nil];
    }
    return self;
}
- (void)dealloc{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"选择采购单";
    [self initData];
    [self bulidLayout];
    [self getData];
}
- (void)initData{
    self.dataArr = [NSMutableArray array];
    self.indexArr = [NSMutableArray array];
}
- (void)getData{
    [ICRUserUtil sharedInstance].needFresh = NO;
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        [strongSelf fetchtPuchaseList:data];
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    ICRUserUtil *userUtil = [ICRUserUtil sharedInstance];
    
    NSMutableArray *orderArr =[NSMutableArray array];

    if (orderArr.count == 0) {
        QueryOrder *order = [QueryOrder new];
        order.field = @"billNumber";
        order.direction = @"desc";
        [orderArr addObject:[order dictForCommit]];
        
    }
    NSDictionary *dict = @{
                           @"state":@"submitted",
                           @"queryOrders":orderArr,
                           @"userUuid":userUtil.userId,
                           @"pageNumber":@(0),
                           @"pageSize":@(20)};
    [[ICRHTTPController sharedController] queryPurchaseWithData:dict success:succ failure:fail];
}
- (void)fetchtPuchaseList:(id)data{
    if (data) {
        NSInteger success = [data[@"success"] integerValue];
        NSString *message  = data[@"message"] ;
        if (success == 1) {
            NSArray *recodesArr = data[ @"data" ][ @"records" ];
            for (NSDictionary *purchaseBillDict in recodesArr) {
                PurchaseBill *purchaseBill = [[PurchaseBill alloc]init];
                [purchaseBill setValuesForKeysWithDictionary:purchaseBillDict];
                [self.dataArr addObject:purchaseBill];
            }
            [self.tableView reloadData];
        }else{
            [IBTLoadingView showTips:message];
        }
        
    }
    else{
        [IBTLoadingView showTips:@"      无记录      "];
    }
}
#pragma mark - 布局
- (void)bulidLayout
{
    self.selectTextFiled = [[UITextField alloc] initWithFrame:CGRectMake(20,5,ScreenSize.width - 40,TopMargin -10)];
    self.selectTextFiled.textAlignment = NSTextAlignmentLeft;
    self.selectTextFiled.background = [UIImage imageNamed:@"textFiled"];
    self.selectTextFiled.delegate = self;
    self.selectTextFiled.font = GXF_FIFTEENTEN_SIZE;
    [self.view addSubview:self.selectTextFiled];
    
    UIImageView *leftView = [[UIImageView alloc]initWithFrame:CGRectMake(0, 0, 35, 40)];
    leftView.image = [UIImage imageNamed:@"search"];
    self.selectTextFiled.leftView = leftView;
    self.selectTextFiled.leftViewMode = UITextFieldViewModeAlways;
    
    UIButton *rightView = [UIButton buttonWithType:UIButtonTypeCustom];
    [rightView setImage:[UIImage imageNamed:@"delete"] forState:UIControlStateNormal];
    rightView.frame = CGRectMake(0, 0, 35, 40);
    [rightView addTarget:self action:@selector(deleteTextFieldStr) forControlEvents:UIControlEventTouchUpInside];
    self.selectTextFiled.rightView = rightView;
    self.selectTextFiled.rightViewMode = UITextFieldViewModeAlways;
    
    
    self.tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, TopMargin,ScreenSize.width, ScreenSize.height - 64 - TopMargin)) style:(UITableViewStylePlain)];
    self.tableView.backgroundColor = [UIColor whiteColor];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    self.tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    [self.view addSubview:self.tableView];
    
    
    UIBarButtonItem *rightItem = [[UIBarButtonItem alloc]initWithTitle:@"确定" style:UIBarButtonItemStylePlain target:self action:@selector(sureClick)];
    self.navigationItem.rightBarButtonItem = rightItem;
}

- (void)deleteTextFieldStr{
    self.selectTextFiled.text = @"";
}
#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"TransPortPurchase";
    TransportPurchaseCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[TransportPurchaseCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
    }
    if(self.dataArr.count > 0){
        PurchaseBill *bill = _dataArr[indexPath.row];
        NSMutableArray *arr = [NSMutableArray array];
        PurchaseBillProduct *billProduct = [PurchaseBillProduct new];
        
            billProduct.product_name = @"dd";
            billProduct.product_uuid  = @"402880e64e287fe2014e28895b8a0032";
            billProduct.product_code = @"农夫山泉";
            billProduct.qpc = [NSNumber numberWithFloat:22];
            billProduct.unit = @"筐";
            billProduct.qty = [NSNumber numberWithFloat:23];
            billProduct.price = [NSNumber numberWithFloat:333];
            billProduct.baseQty = [NSNumber numberWithFloat:333];
            billProduct.basePrice = [NSNumber numberWithFloat:33];
            billProduct.total = [NSNumber numberWithFloat:80];
            billProduct.remark = @"hshshshsh";
            billProduct.qpcStr = @"fdsfdsfdsa";
            [arr addObject:billProduct];
            [arr addObject:billProduct];
        bill.products = arr;
        cell.bill = bill;
    }
    return cell;
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return 200;
}
#pragma mark - 按钮确定
- (void)sureClick{
    [self PopViewControllerAnimated:YES];
    if (self.indexArr.count > 0) {
        self.getProchaseProduct(self.indexArr);
    }
}
#pragma mark - 得到通知的方法
- (void)getSelectPurchaseProduct:(NSNotification *)fination{
   NSDictionary *dict = fination.userInfo;
    PurchaseBillProduct *billProduct = dict[@"selectArr"];
    NSString *state = dict[@"state"];
    if ([state isEqualToString:@"add"]) {
        [self.indexArr addObject:billProduct];
    }else{
        [self.indexArr removeObject:billProduct];
    }
    
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
