//
//  NewTransportViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/6.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "NewTransportViewController.h"
#import "TopTransportView.h"
#import "BottomTransportView.h"
#import "TransportPurchaseViewController.h"
#import "PurchaseBillProduct.h"
#import "FeeAcountDetail.h"
typedef enum : NSUInteger {
    SaveTag = 7000,
    CommitTag,
} BtnTag;

#define TopHeight 284
#define BottomHeight 300
#define SpaceHeight 20
#define BottomViewHeight 60
@interface NewTransportViewController ()<TopTransportViewDelegate,UIScrollViewDelegate>
{
    UIScrollView *_scrollView;
    TopTransportView *_sheetView;
    BottomTransportView *_bottomView;
    id uuidObject;
    id billNumberObject;
    NSNumber *versionObject;
}

@end

@implementation NewTransportViewController

- (instancetype)init{
    self = [super init];
    if (self) {
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(choseTransportPurchase) name:@"ChoseTransportPurchase" object:nil];
    }
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"新建发运单";
    //布局
    [self bulidLayout];
    uuidObject = [NSNull null];
    billNumberObject = [NSNull null];
    versionObject = [NSNumber numberWithInteger:0];
//    if (self.purchaseBill) {
//        [self getDataFromServer];
//    }
}
- (void)bulidLayout{
    self.view.backgroundColor  = XXFBgColor;
    _scrollView = [[UIScrollView alloc]initWithFrame:CGRectMake(0,0, ScreenSize.width, ScreenSize.height- 64 - BottomViewHeight )];
    _scrollView.showsHorizontalScrollIndicator  = NO;
    _scrollView.showsVerticalScrollIndicator = NO;
    _scrollView.contentSize = CGSizeMake(ScreenSize.width, TopHeight+ BottomHeight + SpaceHeight*2);
    [self.view addSubview:_scrollView];
    
    
    UIView *footView = [[UIView alloc]initWithFrame:CGRectMake(0, ScreenSize.height - BottomViewHeight - 64, ScreenSize.width, BottomViewHeight)];
    UIButton *saveBtn =  [IBTCustomButtom creatButtonWithFrame:CGRectMake(15, 8, (ScreenSize.width - 15*3)/2, 44) target:self sel:@selector(btnClick:) tag:SaveTag image:nil title:@"保存" titleColor: [UIColor whiteColor] isCorner:YES corner:5 bgColor:GXF_SAVE_COLOR];
    [footView addSubview:saveBtn];
    
    UIButton *commitBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(CGRectGetMaxX(saveBtn.frame) + 15, 8, (ScreenSize.width - 15*3)/2, 44) target:self sel:@selector(btnClick:) tag:CommitTag image:nil title:@"提交" titleColor: [UIColor whiteColor] isCorner:YES corner:5 bgColor:GXF_COMMIT_COLOR];
    [footView addSubview:commitBtn];
    
    [self.view addSubview:footView];
    
    _sheetView = [[TopTransportView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, TopHeight)];
    _sheetView.delegate = self;
    [_scrollView addSubview:_sheetView];
    
    _bottomView = [[BottomTransportView alloc]initWithFrame:CGRectMake(0, CGRectGetMaxY(_sheetView.frame) + 20, ScreenSize.width,BottomHeight)];
    _bottomView.backgroundColor = [UIColor whiteColor];
    [_scrollView addSubview:_bottomView];
}
- (void)btnClick:(UIButton *)btn{
    switch (btn.tag) {
        case SaveTag:
        {
            if ([self checkTransport]) {
                [self getDataFromServer:PURCHASE_STATE_INITIAL msg:@"正在保存..."];
            }
        }
            break;
        case CommitTag:{
            if ([self checkTransport]) {
                [self getDataFromServer:PURCHASE_STATE_SUBMITTED msg:@"正在提交..."];
                
            }
        }
            break;
        default:
            break;
    }
}
- (void)getDataFromServer:(NSString *)state msg:(NSString *)msg{
    //保存
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message = data[@"message"];
            if (success == 1) {
                //成功
                if ([state isEqualToString:PURCHASE_STATE_INITIAL]) {//保存成功
                    NSString *uuidS = data[@"data"][@"uuid"];
                    NSString *billNumberS = data[@"data"][@"billNumber"];
                    NSNumber *versionN = data[@"data"][@"version"];
                    uuidObject = uuidS;
                    billNumberObject = billNumberS;
                    versionObject = versionN;
                    [IBTLoadingView showTips:[NSString stringWithFormat:@"当前单据%@已保存成功",billNumberS]];
                }else{//提交成功
//                    PurchaseViewController *svc = [PurchaseViewController new];
//                    [self PushViewController:svc animated:YES];
                }
            }else{
                [IBTLoadingView showTips:message];
            }
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    
    if(self.transport.uuid.length > 0 && uuidObject == [NSNull null]){
        uuidObject = self.transport.uuid;
    }
    if (self.transport.billnumber > 0 && billNumberObject == [NSNull null]) {
        billNumberObject = self.transport.billnumber;
    }
//    if (self.purchaseBill && [versionObject integerValue] == 0) {
//        versionObject = self.transport.version;
//    }
    NSMutableArray *billProducts = [NSMutableArray array];
    for (PurchaseBillProduct *billProduct in _bottomView.productVC.productArr) {
        [billProducts  addObject:[billProduct dictForCommit]];
    }
    NSMutableArray *costs = [NSMutableArray array];
    for (FeeAcountDetail *fee in _bottomView.costVC.costArr) {
        [costs  addObject:[fee dictForCommit]];
    }
//    self.state = state;
    NSDictionary *dict = @{@"uuid":uuidObject,
//                           @"version":versionObject,
                           @"billnumber":billNumberObject,
                           @"state":state,
                           @"warehouseUuid":[IBTCommon checkString:_sheetView.warehouseUuid],
                           @"warehouseCode":[IBTCommon checkString:_sheetView.warehouseCode],
                           @"warehouseName":[IBTCommon checkString:_sheetView.warehouseName],
                           @"rwarehouseUuid":[IBTCommon checkString:_sheetView.rwarehouseUuid],
                           @"rwarehouseCode":[IBTCommon checkString:_sheetView.rwarehouseCode],
                           @"rwarehouseName":[IBTCommon checkString:_sheetView.rwarehouseName],
                           @"carnumber":[IBTCommon checkString:_sheetView.carnumber],
                           @"type":[IBTCommon checkString:_sheetView.type],
                           @"carphone":[IBTCommon checkString:_sheetView.carphone],
                           @"note":_sheetView.note,
                           @"pdtDetails":billProducts,
                           @"accountDetails":costs};
    [IBTLoadingView showProgressLabel:msg];
    [[ICRHTTPController sharedController] savePurchaseWithData:dict success:succ failure:fail];
}



- (BOOL)checkTransport{
    _sheetView.note = _sheetView.remarkTextView.text;
    _sheetView.carnumber = _sheetView.carTextFiled.text;
    _sheetView.carphone = _sheetView.phoneTextFiled.text;

    if (_sheetView.warehouseName.length == 0 ) {
        ShowMessage(@"发货仓库不能为空");
        return NO;
    }
    if (_sheetView.rwarehouseUuid.length == 0 ) {
        ShowMessage(@"收货仓库不能为空");
        return NO;
    }
    
    if (_sheetView.type.length == 0 ) {
        ShowMessage(@"运输类型不能为空");
        return NO;
    }
    if (_sheetView.carnumber.length == 0) {
        ShowMessage(@"车牌号不能为空");
        return NO;
    }
    if (_sheetView.carphone.length == 0) {
        ShowMessage(@"司机电话不能为空");
        return NO;
    }
    if (_bottomView.productVC.productArr.count == 0) {
        ShowMessage(@"商品不能为空");
        return NO;
    }
    if (_bottomView.costVC.costArr.count == 0) {
        ShowMessage(@"费用不能为空");
        return NO;
    }
    return YES;
}



- (void)choseTransportPurchase{
    TransportPurchaseViewController *tpv = [TransportPurchaseViewController new];
    tpv.getProchaseProduct = ^(NSArray *products){
        [_bottomView refreshProduct:products];
    };
    [self PushViewController:tpv animated:YES];
}

#pragma mark - TopPurchaseViewDelegate

- (void)pushNextViewController:(id)vc{
    [self PushViewController:vc animated:YES];
}
#pragma mark - 协议方法
- (void)hiddenKeyBoard{
    [self keyboardHidden];
}
- (void)keyboardHidden{
    [_sheetView.phoneTextFiled resignFirstResponder];
    [_sheetView.carTextFiled resignFirstResponder];
    [_sheetView.remarkTextView resignFirstResponder];
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
