//
//  ICRPatrolDetailViewController.m
//  XFFruit
//
//  Created by Xummer on 4/11/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "ICRPatrolDetailViewController.h"
#import "IBTTableViewInfo.h"
#import "IBTTableView.h"

#import "ICRQuestionBaseViewController.h"

#import "ICRQuestionManager.h"
#import "ICRPatrolPlan.h"
#import "ICRStore.h"

#define PATROL_DETAIL_CELL_CONTENT_LABEL_HORIZON_MARGIN     (15)
#define PATROL_DETAIL_CELL_CONTENT_LABEL_VERTICAL_MARGIN    (10)
#define PATROL_DETAIL_CELL_CONTENT_LABEL_FONT               [UIFont systemFontOfSize:15]

@interface ICRPatrolDetailViewController ()

@property (strong, nonatomic) IBTTableViewInfo *m_tableViewInfo;

@property (strong, nonatomic) ICRPatrolPlan *m_plan;

@property (copy, nonatomic) NSString* m_storeID;

@end

@implementation ICRPatrolDetailViewController

#pragma mark - Life Cycle
- (instancetype)initWithPatrolPlan:(id)plan storeID:(NSString *)storeID {
    self = [super init];
    if (!self) {
        return nil;
    }
    
    if ([plan isKindOfClass:[ICRPatrolPlan class]]) {
        self.m_plan = plan;
    }
    
    self.m_storeID = storeID;
    
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.title = [IBTCommon localizableString:@"Patrol Detail"];
    
    [self initTableViewInfo];
    [self updateContent];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Method

- (void)initTableViewInfo {
    
    self.m_tableViewInfo = [[IBTTableViewInfo alloc] initWithFrame:self.view.bounds
                                                            style:UITableViewStylePlain];
   
    IBTTableView *tableV = [_m_tableViewInfo getTableView];
    
    // Footer
    UIButton *btn = nil;
    UIView *tableFooter =
    [tableV buttonViewWithTitle:@"开始"
                          color:ICR_ORANGE_BTN_COLOR
                         topGap:25
                        pointer:&btn
                         target:self
                         action:@selector(startButtonAction:)];
    tableV.tableFooterView = tableFooter;
    
    
    [self.view addSubview:tableV];
    
    // # Section 0
    IBTTableViewSectionInfo *sec0Info = [IBTTableViewSectionInfo sectionInfoDefaut];
    
    // User ID
    IBTTableViewCellInfo *titleCellInfo =
    [IBTTableViewCellInfo normalCellForSel:nil target:nil
                                    title:[IBTCommon localizableString:@"Title"]
                               rightValue:@""
                             accessoryType:UITableViewCellAccessoryNone];
    titleCellInfo.selectionStyle = UITableViewCellSelectionStyleNone;
    
    [sec0Info addCell:titleCellInfo];
    
    IBTTableViewCellInfo *typeCellInfo =
    [IBTTableViewCellInfo normalCellForSel:nil target:nil
                                     title:[IBTCommon localizableString:@"Type"]
                                rightValue:@""
                             accessoryType:UITableViewCellAccessoryNone];
    typeCellInfo.selectionStyle = UITableViewCellSelectionStyleNone;
    
    [sec0Info addCell:typeCellInfo];
    
    IBTTableViewCellInfo *planTimeCellInfo =
    [IBTTableViewCellInfo normalCellForSel:nil target:nil
                                     title:[IBTCommon localizableString:@"Scheduled Time"]
                                rightValue:@""
                             accessoryType:UITableViewCellAccessoryNone];
    planTimeCellInfo.selectionStyle = UITableViewCellSelectionStyleNone;
    
    [sec0Info addCell:planTimeCellInfo];
    
    IBTTableViewCellInfo *startTimeCellInfo =
    [IBTTableViewCellInfo normalCellForSel:nil target:nil
                                     title:[IBTCommon localizableString:@"Start Time"]
                                rightValue:@""
                             accessoryType:UITableViewCellAccessoryNone];
    startTimeCellInfo.selectionStyle = UITableViewCellSelectionStyleNone;
    
    [sec0Info addCell:startTimeCellInfo];
    
    IBTTableViewCellInfo *contentCellInfo =
    [[IBTTableViewCellInfo alloc] init];
    contentCellInfo.makeTarget = self;
    contentCellInfo.makeSel = @selector(makeContentCell:);
    contentCellInfo.calHeightTarget = self;
    contentCellInfo.calHeightSel = @selector(calContentCellHeight:);
    contentCellInfo.selectionStyle = UITableViewCellSelectionStyleNone;
    [sec0Info addCell:contentCellInfo];
    
    [_m_tableViewInfo addSection:sec0Info];

}

- (void)makeContentCell:(IBTTableViewCellInfo*)cellInfo {
    
    IBTTableViewCell *cell = cellInfo.cell;
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    [cell.contentView removeAllSubViews];
    
    UIView *contentView = cell.contentView;
    
    IBTUILabel *titleLabel = [[IBTUILabel alloc] init];
    
    NSString *rightValue = [cellInfo getUserInfoValueForKey:CInfoDetailKey];
    titleLabel.text = rightValue;
    titleLabel.textColor = [UIColor colorWithW:135.0f a:1];
    titleLabel.font = PATROL_DETAIL_CELL_CONTENT_LABEL_FONT;
    titleLabel.numberOfLines = 0;
    CGSize titleLabelSize = [titleLabel sizeThatFits:CGSizeMake(contentView.width - PATROL_DETAIL_CELL_CONTENT_LABEL_HORIZON_MARGIN * 2, MAXFLOAT)];
    titleLabel.frame = ((CGRect){
        .origin.x = PATROL_DETAIL_CELL_CONTENT_LABEL_HORIZON_MARGIN,
        .origin.y = PATROL_DETAIL_CELL_CONTENT_LABEL_VERTICAL_MARGIN,
        .size = titleLabelSize
    });
    
//    cellInfo.fCellHeight = titleLabel.height + PATROL_DETAIL_CELL_CONTENT_LABEL_VERTICAL_MARGIN * 2;
    
    [contentView addSubview:titleLabel];
}

- (CGFloat)calContentCellHeight:(IBTTableViewCellInfo*)cellInfo {
    NSString *rightValue = [cellInfo getUserInfoValueForKey:CInfoDetailKey];
    IBTTableView *tableV = [_m_tableViewInfo getTableView];
    return [UILabel getHeightWithText:rightValue font:PATROL_DETAIL_CELL_CONTENT_LABEL_FONT
                             andWidth:tableV.width - PATROL_DETAIL_CELL_CONTENT_LABEL_HORIZON_MARGIN * 2] + PATROL_DETAIL_CELL_CONTENT_LABEL_VERTICAL_MARGIN * 2;
}

- (void)updateContent {
    
    IBTTableViewCellInfo *cellInfo =
    [self.m_tableViewInfo getCellAtSection:0 row:0];
    [cellInfo addUserInfoValue:_m_plan.name
                        forKey:CInfoRightValueKey];
    
    cellInfo =
    [self.m_tableViewInfo getCellAtSection:0 row:1];
    [cellInfo addUserInfoValue:_m_plan.category
                        forKey:CInfoRightValueKey];
    
    NSString *nsStart = [[_m_plan.beginDate componentsSeparatedByString:@" "] firstObject];
    NSString *nsEnd = [[_m_plan.endDate componentsSeparatedByString:@" "] firstObject];
    
    cellInfo =
    [self.m_tableViewInfo getCellAtSection:0 row:2];
    [cellInfo addUserInfoValue:[NSString stringWithFormat:@"%@~%@", nsStart, nsEnd]
                        forKey:CInfoRightValueKey];
    
    cellInfo =
    [self.m_tableViewInfo getCellAtSection:0 row:3];
    [cellInfo addUserInfoValue:[[NSDate date] httpParameterString]
                        forKey:CInfoRightValueKey];
    
    cellInfo =
    [self.m_tableViewInfo getCellAtSection:0 row:4];
    [cellInfo addUserInfoValue:_m_plan.remark
                        forKey:CInfoDetailKey];
    
    [[_m_tableViewInfo getTableView] reloadData];
}

#pragma mark - Button Actions

- (void)startButtonAction:(id)sender {
    
    ICRDatabaseFetchBlock fetchBlk = ^FMResultSet *(FMDatabase *db) {
        NSString * sql = [NSString stringWithFormat:@"SELECT * FROM %@ WHERE %@ == ?", [ICRStore TableName], @"uuid"];
        return [db executeQuery:sql, _m_storeID];
    };
    __weak typeof(self)weakSelf = self;
    ICRDatabaseFetchResultsBlock fetchResultsBlk = ^(NSArray *fetchedObjects) {
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        
        ICRQuestionManager *mgr = [ICRQuestionManager sharedManager];
        mgr.m_storeID = _m_storeID;
        mgr.m_store = [fetchedObjects firstObject];
        [mgr openQuestionVCFromViewControler:strongSelf withPlan:_m_plan];
    };
    
    ICRDataBaseController *dbCtrl = [ICRDataBaseController sharedController];
    [dbCtrl runFetchForClass:[ICRStore class]
                  fetchBlock:fetchBlk
           fetchResultsBlock:fetchResultsBlk];
}
@end
